#include <cstdlib>
#include <cstdio>
#include <iomanip>
#include <iostream>
#include <fstream>
#include <string>
#include <cmath>
#include <mkl.h>

#define ERR_NEGATIVE_RADICANT 1
#define ERR_SEMIDEFINITE      2
#define ERR_DIAG_ZERO         3

using namespace std;

typedef long long int INTEGER8;

//=============================================================================

void read_csr(string FileName, int *&Ptr, int *&Key, double *&Mat, int *N);

//=============================================================================
//
int sp_chol_decomp_csr(int *&LPtr, int *&LKey, double *&LMat, int *LTPtr, int
		*LTKey, double *LTMat, int *APtr, int *AKey, double *AMat, int
		*N, double *thresh, double *semithresh, bool *semidefinite,
		bool *ok);

int sp_chol_inv_csr(int *LPtr, int *LKey, double *LMat, int *LIPtr, int *LIKey,
		double *LIMat, int *N, double *thresh, double *diagthresh, bool
		*ok);

void sp_mult_csr_sym(int *CPtr, int *CKey, double *CMat, int *APtr, int *AKey,
		double *AMat, int *BPtr, int *BKey, double *BMat, int *N,
		double *thresh, double *scr);

void sp_mult_csr(int *CPtr, int *CKey, double *CMat, int *APtr, int *AKey,
		double *AMat, int *BPtr, int *BKey, double *BMat, int *N,
		double *thresh, double *scr);

//=============================================================================

void sp_killtri_csr(int* APtr, int* AKey, double* AMat, int *N);

void sp_keymerge_csr(int *AKey, int *BKey, int *CKey, int *Adim, int *Bdim, int
		*N);

void sp_trapos_csr(int *APtr, int *AKey, double *AMat, int *BPtr, int *BKey,
		double *BMat, int *N);

void sp_symmetrize_csr(int *outPtr, int *outKey, double *outMat, int *inPtr,
		int *inKey, double *inMat, int *N);

//=============================================================================

void sp_chol_solver_csr(double *LTMat, int *LTKey, int *LTPtr, double *b, int
		*N);
	
//=============================================================================
