/******************************************************************************

        Form transposed matrix
        B = A^T

    
        input:
          APtr,AKey,AMat        
	  N                     dimension of matrix A 

        output:
          BPtr,BKey,BMat        transposed of A
  
******************************************************************************/

#include "sparsecholes.h"

void sp_trapos_csr(int *APtr, int *AKey, double *AMat,
                   int *BPtr, int *BKey, double *BMat, int *N){

//=============================================================================

  int i,j,k,ia,ia1,offset;

  for(i = 0; i <= *N; i++) BPtr[i] = 0;

  for(i = 0; i < *N; i++){
    ia  = APtr[i];
    ia1 = APtr[i+1];
    while(ia < ia1){
      k = AKey[ia];
      BKey[k*(*N) + BPtr[k+1]]  = i;
      BMat[k*(*N) + BPtr[k+1]]  = AMat[ia];
      BPtr[k+1]                += 1;
      ia++;
    }
  }

  for(i = 1; i <= *N; i++){
    BPtr[i] += BPtr[i-1];
  }

  for(i = 1; i < *N; i++){
    offset = BPtr[i];
    k = i*(*N);
    for(j = 0; j < (BPtr[i+1]-BPtr[i]); j++){
      BKey[j+offset] = BKey[j+k];
      BMat[j+offset] = BMat[j+k];
    }
  }

//=============================================================================

}

