/******************************************************************************

	Symmetrize a matrix

        input:
          inPtr,inKey,inMat
          N			dimension of matrix 

        output:
          outPtr,outKey,outMat

******************************************************************************/

#include "sparsecholes.h"

void sp_symmetrize_csr(int *outPtr, int *outKey, double *outMat, int *inPtr,
                       int *inKey, double *inMat, int *N){

//=============================================================================

  int i,j,k;
  int idx,idx1;
  int offset;
  int N2 = *N**N;

  for(i=0; i<=*N; i++) outPtr[i] = 0;
  for(i=0; i<N2; i++){
    outKey[i] = 0; 
    outMat[i] = 0.e0;
  }
  for(i=0; i<*N; i++){
    idx  = inPtr[i];
    idx1 = inPtr[i+1];
    while(inKey[idx] < i && idx < idx1) idx++;
    while(idx < idx1){
      k = inKey[idx];
      outKey[k**N + outPtr[k+1]]  = i;
      outMat[k**N + outPtr[k+1]]  = inMat[idx];
      outPtr[k+1]               += 1;
      idx++;
    }
  }
  for(i=0; i<*N; i++){
    idx  = inPtr[i];
    idx1 = inPtr[i+1];
    while(inKey[idx] <= i && idx < idx1) idx++;
    while(idx < idx1){
      outKey[i**N + outPtr[i+1]]  = inKey[idx];
      outMat[i**N + outPtr[i+1]]  = inMat[idx];
      outPtr[i+1]               += 1;
      idx++;
    }
  }
  for(i=1; i<=*N; i++){
    outPtr[i] += outPtr[i-1];
  }

//-----------------------------------------------------------------------------
// kick out spaces between rows...

  for(i=1; i<*N; i++){
    offset = outPtr[i];
    k = i**N; 
    for(j=0; j<(outPtr[i+1]-outPtr[i]); j++){
      outKey[j+offset] = outKey[j+k];
      outMat[j+offset] = outMat[j+k];
    }

  }
//=============================================================================

}

