/******************************************************************************

        Sparse matrix multiplication, forming only upper triangluar of C
        C = A * B

        input:
          APtr,AKey,AMat        
          BPtr,BKey,BMat        
          N                     dimension of matrix A 
          thresh                sparse threshold
          scr                   help array of dimension N

        output:
          CPtr,CKey,CMat        

******************************************************************************/

#include "sparsecholes.h"

void sp_mult_csr_sym(int *CPtr, int *CKey, double *CMat,
                     int *APtr, int *AKey, double *AMat,
                     int *BPtr, int *BKey, double *BMat,
                     int *N, double *thresh, double *scr){

//=============================================================================

  int    i,j,k,l;
  int    ia,ib,ia1,ib1;
  int    index=0;
  double Aik,value;

  for (i=0; i < (*N); i++){

    for(j=i; j < (*N); j++) scr[j] = 0.e0;

    ia  = APtr[i];
    ia1 = APtr[i+1];

    while (ia < ia1){

      Aik = AMat[ia];
      k   = AKey[ia];
      ib  = BPtr[k];
      ib1 = BPtr[k+1];

      //only the upper triangle of C
      while(BKey[ib] < i && ib < ib1) ib++;

      while (ib < ib1){

        j = BKey[ib];
        scr[j] += Aik * BMat[ib];
        ib = ib + 1;
      }
      ia = ia + 1;
    }

    CPtr[i] = index;

    for (l=i; l < (*N); l++){
      value = scr[l];
      if ((fabs(value) >= (*thresh))) {
        CMat[index]   = value;
        CKey[index++] = l;
      }
    }

  }

  CPtr[(*N)] = index;

//=============================================================================

}
