/******************************************************************************

	Remove matrix entries from lower triangular
	(input will be overwritten)

        input:          
	  APtr,AKey,AMat 	full matrix 
	  N                     dimension of matrix A

        output:      
	  APtr,AKey,AMat 	halved matrix

******************************************************************************/

#include "sparsecholes.h"

void sp_killtri_csr(int *APtr, int *AKey, double *AMat, int *N){

//=============================================================================
 
  int aj, aj1;
  int new_idx   = 0;
  int begin_row = APtr[0];

//-----------------------------------------------------------------------------

  for (int i=0 ; i < (*N); i++){
    aj  = begin_row;
    aj1 = APtr[i+1];
    begin_row = aj1;
    while (AKey[aj] < i){
      aj++;
    }
    while (aj < aj1){
      AMat[new_idx] = AMat[aj];
      AKey[new_idx] = AKey[aj];

      new_idx++;
      aj++;
    }
    APtr[i+1] = new_idx;
  }

//=============================================================================

}
