/******************************************************************************

	Merge keys of two rows in increasing order using loop-unrolling (4x)

        input:
	  AKey		keys of first matrix
	  BKey		keys of second matrix
	  Adim		length of row of A
	  Bdim		length of row of B
	  N		dimension of matrix A and B, respectively

        output:
	  CKey		merged keys
	  Adim		is overwritten with length of CKey

******************************************************************************/

#include "sparsecholes.h"

void sp_keymerge_csr(int *AKey, int *BKey, int *CKey, int *Adim, int *Bdim, 
                     int *N){ 

//=============================================================================

  int a = 0, b = 0, c = 0, d;
  int A, B;
  int save;

  AKey[*Adim] = *N;
  save = BKey[*Bdim];
  BKey[*Bdim] = *N;

  int aa = *Adim - 3;
  int bb = *Bdim - 3;

//=============================================================================

  while (a < aa || b < bb){
    A = AKey[a];
    B = BKey[b];
    if (A == B){
      CKey[c] = A;
      a++;
      b++;
    }else if (A < B){
      CKey[c] = A;
      a++;
    }else if (A > B){
      CKey[c] = B;
      b++;
    }
    c++;

    A = AKey[a];
    B = BKey[b];
    if (A == B){
      CKey[c] = A;
      a++;
      b++;
    }else if (A < B){
      CKey[c] = A;
      a++;
    }else if (A > B){
      CKey[c] = B;
      b++;
    }
    c++;

    A = AKey[a];
    B = BKey[b];
    if (A == B){
      CKey[c] = A;
      a++;
      b++;
    }else if (A < B){
      CKey[c] = A;
      a++;
    }else if (A > B){
      CKey[c] = B;
      b++;
    }
    c++;

    A = AKey[a];
    B = BKey[b];
    if (A == B){
      CKey[c] = A;
      a++;
      b++;
    }else if (A < B){
      CKey[c] = A;
      a++;
    }else if (A > B){
      CKey[c] = B;
      b++;
    }
    c++;

  }
  aa += 3;
  bb += 3;

//-----------------------------------------------------------------------------
// do the rest, if Adim/Bdim are not divisible by 4

  while (a < aa || b < bb){
    A = AKey[a];
    B = BKey[b];
    if (A == B){
      CKey[c] = A;
      a++;
      b++;
    }else if (A < B){
      CKey[c] = A;
      a++;
    }else if (A > B){
      CKey[c] = B;
      b++;
    }
    c++;
  }

  *Adim = c;

  BKey[*Bdim] = save;

//=============================================================================

}
