/******************************************************************************

	Linear equation solver
        A x = b

        input:
          LTPtr,LTKey,LTMat	transposed Cholesky factor of A
          N                     dimension of matrix A 
	  b			vector

        output:
	  b			b is overwritten with x


	L  * LT * x = b
               = c		
	L  * c      = b
        LT * x      = c

******************************************************************************/

#include "sparsecholes.h"

void sp_chol_solver_csr(double *LTMat, int *LTKey, int *LTPtr, double *b, 
                        int *N){

//=============================================================================

  int     N2 = (*N)*(*N);
  int     i,j,idx,
  int     lt,lt1,col;
  double  inv_diag,val,bi;
  double  * bptr = NULL;

  //scale vector b
  for(i = 0; i < (*N); i++){
    idx   = LTPtr[i];
    b[i] /= LTMat[idx]; 
  }

  //solve LT * c = b for c, b is overwritten with c
  for(i = 0; i < (*N); i++){
    lt  = LTPtr[i]+1;
    lt1 = LTPtr[i+1];
    bi  = b[i];

    //c_i = b_i/LT_ii - sum LT_ji * c_j with j=1,...,j<i
    for(lt; lt < lt1; lt++){
      col = LTKey[lt];
      idx = LTPtr[col];
      b[col] -= LTMat[lt]*bi/LTMat[idx];
    }
  }
  //scale vector c (stored in b)
  for(i=0; i<(*N); i++){
    idx   = LTPtr[i];
    b[i] /= LTMat[idx];
  }

  //solve LT * x = c (stored in b) for x, b is overwritten with x
  bptr = b + ((*N)-1);
  for(i = ((*N)-1); i >= 0; i--){
    lt  = LTPtr[i]+1;
    lt1 = LTPtr[i+1];
    idx = LTPtr[i];
    inv_diag = 1.e0/LTMat[idx];
    
    //x_i = c_i/LT_ii - sum LT_ij * x_j with j=i+1,...,N
    for(lt; lt < lt1; lt++){
      col    = LTKey[lt];
      *bptr -= LTMat[lt]*b[col]*inv_diag;
    }
    bptr--;
  }

//=============================================================================

}
