/******************************************************************************

        Form inverse L^-1 of Cholesky factor L

        input:
          LPtr,LKey,LMat        matrix to be decomposed
          N                     dimension of matrix A 
          thresh                sparse threshold
                                threshold below 10^-6 is not recommended
          diagthresh            threshold for diagonal elements of L
          ok                    true  = ok, false = negative radicant

        output:
          LIPtr,LIKey,LIMat     inverse Cholesky factor

******************************************************************************/

#include "sparsecholes.h"

int sp_chol_inv_csr(int *LPtr, int *LKey, double *LMat, int *LIPtr, int *LIKey,
		    double *LIMat, int *N, double *thresh, double *diagthresh,
                    bool *ok){

//=============================================================================

  //allocation
  int     i,j,k,liidx,l,n,r,  
          li,li1,lik,lik1,jx,
          lrowlen,lirowlen,keylen;
  double  idiag, ldiag, Lik;
  double  Ihlp;
  int*    KeySwap = NULL;

  int    *Index      = new int[(*N)];
  int    *TmpKey     = new int[(*N)+1];
  int    *MergedKeys = new int[(*N)+1];

  double *diagLI = new double[(*N)];
  double *CurrentRow = new double[(*N)];

  for(i = 0; i < (*N); i++){
    Index[i]      = 0;
    CurrentRow[i] = 0;
    diagLI[i]        = 0.e0;
  }
  for(i = 0; i < (*N)+1; i++){
    TmpKey[i]     = 0;
    MergedKeys[i] = 0;
  }

  //first settings
  LIPtr[0] = 0;
  liidx    = 0;
  jx       = 0;

  //form diagonal elements
  for (i = 0; i < (*N); i++){
    if(LMat[LPtr[i+1] - 1] <= *diagthresh){
       *ok = false;
       return ERR_DIAG_ZERO;
    }
    diagLI[i] = 1.e0/LMat[LPtr[i+1] - 1];
  }


  //scale rows of LL
  for (i = 0; i < (*N); i++){
    li    = LPtr[i]; 		
    li1   = LPtr[i+1]-1;		//skip diagonal element ...
    idiag = diagLI[i];
    for (li; li < li1; li++){
       LMat[li] *= idiag; 
    }
  }

  //offdiagonal elements
  for (i = 0; i < (*N); i++){

    jx++;
    //write keys of current row of L in MergedKeys
    li       = LPtr[i];
    li1      = LPtr[i+1]-1;
    LIPtr[i] = liidx;
    lrowlen  = li1 - li;
    KeySwap = LKey + li;
    for(j=0;j<lrowlen;j++) MergedKeys[j] = KeySwap[j];
    MergedKeys[lrowlen] = lrowlen;
    KeySwap = NULL;
    keylen  = lrowlen;

    //form l_ik * l_kj^-1 with k=j,...,i-1
    for (li; li < li1; li++){
      k    = LKey[li];
      lik  = LIPtr[k];
      lik1 = LIPtr[k+1]-1;
      Lik  = LMat[li];
      CurrentRow[k] = -Lik * diagLI[k];
      Index[k]      = jx;
      lirowlen      = lik1 - lik;
      //merge keys of current rows of L and L^-1 in increasing order
      sp_keymerge_csr(MergedKeys, LIKey+lik, TmpKey, &keylen, &lirowlen, N);

      //swap pointers
      KeySwap    = MergedKeys;
      MergedKeys = TmpKey;
      TmpKey     = KeySwap;
      KeySwap    = NULL;

      for (lik; lik < lik1; lik++){
        k = LIKey[lik];
        //if no fill in element, subtract from 1/l_ii
        if (Index[k] == jx){
          CurrentRow[k] -= Lik * LIMat[lik];
        }
        //if fill in element, set value
        else{
          CurrentRow[k] = -Lik * LIMat[lik];
          Index[k] = jx;
        }
      }
    }

    //sort current row in LI
    for (r = 0; r < keylen; r++){
      j = MergedKeys[r];
      if (Index[j] != jx) continue;
      Ihlp = CurrentRow[j];
      if (fabs(Ihlp) > *thresh){
        LIMat[liidx] = Ihlp;
        LIKey[liidx] = j;
        liidx++;
      }
    }
    LIMat[liidx] = diagLI[i];
    LIKey[liidx] = i;
    liidx++;
  }   

  LIPtr[(*N)] = liidx;

  delete[] Index;
  delete[] TmpKey;
  delete[] MergedKeys;
  delete[] diagLI;
  delete[] CurrentRow;

//=============================================================================

}
