/******************************************************************************

	Read binary file of matrix in csr format

	input:		
	  N		dimension of matrix A
	  FileName      prefix of matrix name

******************************************************************************/

#include "sparsecholes.h"

void read_csr(string FileName, int *&Ptr, int *&Key, double *&Mat, int *N){

//=============================================================================

  int dim;

  string PtrFileName = FileName + ".idx";
  string MatFileName = FileName + ".mat";
  string KeyFileName = FileName + ".key";

  ifstream file;

//-----------------------------------------------------------------------------

  // read input.idx
  file.open(PtrFileName.c_str(),ifstream::binary);
  if (!file){
    cout << "\nError reading " << PtrFileName << endl;
    exit(1);
  }

  file.read((char*)N,sizeof(int));
  file.read((char*)N,sizeof(int));

  Ptr = new int[(*N)+1];
  file.read((char*)Ptr,((*N)+1)*sizeof(int));

  file.close();

//-----------------------------------------------------------------------------

  // read input.key
  file.open(KeyFileName.c_str(),ifstream::binary);
  if (!file){
    cout << "\nError reading " << KeyFileName << endl;
    exit(1);
  }

  file.read((char*)&dim,sizeof(int));
  Key = new int[dim];
  file.read((char*)Key,dim*sizeof(int));

  file.close();

//-----------------------------------------------------------------------------

  // read input.mat
  file.open(MatFileName.c_str(),ifstream::binary);
  if (!file){
    cout << "\nError reading " << MatFileName << endl;
    exit(1);
  }

  file.read((char*)&dim,sizeof(int));
  Mat = new double[dim];
  file.read((char*)Mat,dim*sizeof(double));

  file.close();

//=============================================================================

}
