from MDAnalysis import Universe
from MDAnalysis.coordinates.DCD import DCDReader
from MDAnalysis.coordinates.TRR import TRRReader
import numpy as np
from numpy.linalg import inv
from optparse import OptionParser


op = OptionParser(usage="./read_traj.py [options]\n\n"+
                                "reads trajectory and removes com trans and rot ...\n")

op.add_option ("-a", "--num-atm", type="int", dest="natm",
                       help="# number of atoms", metavar="INT")
op.add_option ("-p", "--parmfile", type="string", dest="parm",
                       help="# parameter file", metavar="STR")
op.add_option ("-t", "--type", type="string", dest="types",
                       help="# namd or gro", metavar="STR")
op.add_option ("-c", "--coord-dcd", type="string", dest="dcd",
                       help="# dcd that contains coordinates, or trr", metavar="STR")
op.add_option ("-v", "--vel-dcd", type="string", dest="vel",
                       help="# dcd that contains velocities", metavar="STR")

op.set_defaults(natm=0, parm=None, dcd=None, vel=None, types=None)

(opts, args) = op.parse_args ()
opts_dict = vars (opts)

if (opts.natm==0 or opts.parm==None or opts.dcd==None or opts.types==None):
    print "One of the input parameters was not set!"
    exit()

if opts.types=='namd':
    u = Universe(opts.parm, opts.vel)
elif opts.types=='gro':
    u = Universe(opts.parm)


prot = u.select_atoms("all")

# the default for convert units is true!
if opts.types=='namd':
    dcd = DCDReader(opts.vel)
    dcd_coor = DCDReader(opts.dcd)
elif opts.types=='gro':
    trr = TRRReader(opts.dcd)

if opts.types=='namd':
    #fac = 20.45482706 /511.649599 # from NAMD internal units to A/ps and then to amu * v^2 = E_h
    fac = 1.0 / 511.649599 # from AA/ps to sqrt(E_h / amu)
elif opts.types=='gro':
    fac = 1.0 / 511.649599 # from AA/ps to sqrt(E_h / amu)

num_atm = opts.natm 

tot_mass = 0.0
for atom in range(0,num_atm):
	tot_mass += prot[atom].mass

#### com_vel is still there
##for atom in range(0,num_atm):
#for atom in range(0,1):
#    print "Atom: ",atom
#    out_f = open("atom_"+str(atom)+".dat", "w")
#    for time in range(100000,600000):
#        #if time%10000 == 0:
#        #    print "\ttime ",time
#        out_f.write("%8.6f\t%8.6f\t%8.6f\t%8.6f\t%8.3f\n" % (float(time), fac*dcd[time][atom][0], fac*dcd[time][atom][1], fac*dcd[time][atom][2], prot[atom].mass) )
#   
#    out_f.close()


### only remove com vel
#for time in range(100000,1100000):
#    com_vel = dcd[time][0] * prot[0].mass
#    for atom in range(1,num_atm):
#    	com_vel += dcd[time][atom] * prot[atom].mass
#    com_vel /= tot_mass
#    for atom in range(0,num_atm):
#        out_f = open("atom_"+str(atom)+"_nocomvel.dat", "a")
#        out_f.write("%8.6f\t%8.6f\t%8.6f\t%8.6f\t%8.3f\n" % (float(time), fac*(dcd[time][atom][0]-com_vel[0]), fac*(dcd[time][atom][1]-com_vel[1]), fac*(dcd[time][atom][2]-com_vel[2]), prot[atom].mass) )
#        out_f.close()


### remove com vel and then rotation
ang_vel = np.zeros(shape=(3,), dtype=float)

if opts.types=='namd':
    for time in xrange(0, len(dcd)):
        com_vel = dcd[time][0] * prot[0].mass
        for atom in range(1,num_atm):
            com_vel += dcd[time][atom] * prot[atom].mass
        com_vel /= tot_mass
        #
        new_vel = []
        for atom in range(0,num_atm):
        	new_vel.append(dcd[time][atom] - com_vel)
        #
        I_xx = 0.0
        I_yy = 0.0
        I_zz = 0.0
        I_xy = 0.0
        I_xz = 0.0
        I_yz = 0.0
        #
        tot_ang_mom = np.zeros(shape=(3,), dtype=float)
    	#
        for atom in range(0,num_atm):
    		I_xx += prot[atom].mass * (dcd_coor[time][atom][1]**2 + dcd_coor[time][atom][2]**2)
    		I_yy += prot[atom].mass * (dcd_coor[time][atom][0]**2 + dcd_coor[time][atom][2]**2)
    		I_zz += prot[atom].mass * (dcd_coor[time][atom][0]**2 + dcd_coor[time][atom][1]**2)
    		I_xy -= prot[atom].mass * dcd_coor[time][atom][0] * dcd_coor[time][atom][1]
    		I_xz -= prot[atom].mass * dcd_coor[time][atom][0] * dcd_coor[time][atom][2]
    		I_yz -= prot[atom].mass * dcd_coor[time][atom][1] * dcd_coor[time][atom][2]
            #
    		tot_ang_mom[0] += prot[atom].mass * (dcd_coor[time][atom][1]*new_vel[atom][2] - dcd_coor[time][atom][2]*new_vel[atom][1])
    		tot_ang_mom[1] += prot[atom].mass * (dcd_coor[time][atom][2]*new_vel[atom][0] - dcd_coor[time][atom][0]*new_vel[atom][2])
    		tot_ang_mom[2] += prot[atom].mass * (dcd_coor[time][atom][0]*new_vel[atom][1] - dcd_coor[time][atom][1]*new_vel[atom][0]) 
        #
        I = np.array([[I_xx, I_xy, I_xz], [I_xy, I_yy, I_yz], [I_xz, I_yz, I_zz]])
        I_inv = inv(I)
        #
        ang_vel[0] = I_inv[0,0]*tot_ang_mom[0] + I_inv[0,1]*tot_ang_mom[1] + I_inv[0,2]*tot_ang_mom[2]
        ang_vel[1] = I_inv[1,0]*tot_ang_mom[0] + I_inv[1,1]*tot_ang_mom[1] + I_inv[1,2]*tot_ang_mom[2]
        ang_vel[2] = I_inv[2,0]*tot_ang_mom[0] + I_inv[2,1]*tot_ang_mom[1] + I_inv[2,2]*tot_ang_mom[2]	
    	### print / append
        for atom in range(0,num_atm):
            if atom < 10:
                atomstr = '00000'+str(atom)
            elif atom < 100:
                atomstr = '0000'+str(atom)
            elif atom < 1000:
                atomstr = '000'+str(atom)
            elif atom < 10000:
                atomstr = '00'+str(atom)
            elif atom < 100000:
                atomstr = '0'+str(atom)
            else:
                atomstr = str(atom)
            v_ext_x = (ang_vel[1]*dcd_coor[time][atom][2] - ang_vel[2]*dcd_coor[time][atom][1])
            v_ext_y = (ang_vel[2]*dcd_coor[time][atom][0] - ang_vel[0]*dcd_coor[time][atom][2])
            v_ext_z = (ang_vel[0]*dcd_coor[time][atom][1] - ang_vel[1]*dcd_coor[time][atom][0])
            out_f = open("atom_"+atomstr+"_stiff.dat", "a")
            out_f.write("%8.6f\t%8.6f\t%8.6f\t%8.6f\t%8.3f\n" % (float(time), fac*(new_vel[atom][0]-v_ext_x), fac*(new_vel[atom][1]-v_ext_y), fac*(new_vel[atom][2]-v_ext_z), prot[atom].mass) )
            out_f.close()
elif opts.types=='gro':
    for time in xrange(0, len(trr)):
        com_vel = trr[time]._velocities[0] * prot[0].mass
        for atom in range(1,num_atm):
            com_vel += trr[time]._velocities[atom] * prot[atom].mass
        com_vel /= tot_mass
        #
        new_vel = []
        for atom in range(0,num_atm):
        	new_vel.append(trr[time]._velocities[atom] - com_vel)
        #
        I_xx = 0.0
        I_yy = 0.0
        I_zz = 0.0
        I_xy = 0.0
        I_xz = 0.0
        I_yz = 0.0
        #
        tot_ang_mom = np.zeros(shape=(3,), dtype=float)
    	#
        for atom in range(0,num_atm):
    		I_xx += prot[atom].mass * (trr[time][atom][1]**2 + trr[time][atom][2]**2)
    		I_yy += prot[atom].mass * (trr[time][atom][0]**2 + trr[time][atom][2]**2)
    		I_zz += prot[atom].mass * (trr[time][atom][0]**2 + trr[time][atom][1]**2)
    		I_xy -= prot[atom].mass * trr[time][atom][0] * trr[time][atom][1]
    		I_xz -= prot[atom].mass * trr[time][atom][0] * trr[time][atom][2]
    		I_yz -= prot[atom].mass * trr[time][atom][1] * trr[time][atom][2]
            #
    		tot_ang_mom[0] += prot[atom].mass * (trr[time][atom][1]*new_vel[atom][2] - trr[time][atom][2]*new_vel[atom][1])
    		tot_ang_mom[1] += prot[atom].mass * (trr[time][atom][2]*new_vel[atom][0] - trr[time][atom][0]*new_vel[atom][2])
    		tot_ang_mom[2] += prot[atom].mass * (trr[time][atom][0]*new_vel[atom][1] - trr[time][atom][1]*new_vel[atom][0]) 
        #
        I = np.array([[I_xx, I_xy, I_xz], [I_xy, I_yy, I_yz], [I_xz, I_yz, I_zz]])
        I_inv = inv(I)
        #
        ang_vel[0] = I_inv[0,0]*tot_ang_mom[0] + I_inv[0,1]*tot_ang_mom[1] + I_inv[0,2]*tot_ang_mom[2]
        ang_vel[1] = I_inv[1,0]*tot_ang_mom[0] + I_inv[1,1]*tot_ang_mom[1] + I_inv[1,2]*tot_ang_mom[2]
        ang_vel[2] = I_inv[2,0]*tot_ang_mom[0] + I_inv[2,1]*tot_ang_mom[1] + I_inv[2,2]*tot_ang_mom[2]	
    	### print / append
        for atom in range(0,num_atm):
            if atom < 10:
                atomstr = '00000'+str(atom)
            elif atom < 100:
                atomstr = '0000'+str(atom)
            elif atom < 1000:
                atomstr = '000'+str(atom)
            elif atom < 10000:
                atomstr = '00'+str(atom)
            elif atom < 100000:
                atomstr = '0'+str(atom)
            else:
                atomstr = str(atom)
            v_ext_x = (ang_vel[1]*trr[time][atom][2] - ang_vel[2]*trr[time][atom][1])
            v_ext_y = (ang_vel[2]*trr[time][atom][0] - ang_vel[0]*trr[time][atom][2])
            v_ext_z = (ang_vel[0]*trr[time][atom][1] - ang_vel[1]*trr[time][atom][0])
            out_f = open("atom_"+atomstr+"_stiff.dat", "a")
            out_f.write("%8.6f\t%8.6f\t%8.6f\t%8.6f\t%8.3f\n" % (float(time), fac*(new_vel[atom][0]-v_ext_x), fac*(new_vel[atom][1]-v_ext_y), fac*(new_vel[atom][2]-v_ext_z), prot[atom].mass) )
            out_f.close()











