#! /usr/bin/python

import numpy as np
 
from optparse import OptionParser

op = OptionParser(usage="./make_pdb.py -flags filnames\n\n"+
                                "reads in file with grepped dA and pdb and puts in dA per atom in occupancy column\n")

op.add_option ("-A", "--free_energy", type="string", dest="inp",
                       help="# file with free energy differences", metavar="STR")
op.add_option ("-s", "--structure", type="string", dest="struct",
                       help="# input pdb", metavar="STR")
op.add_option ("-o", "--output", type="string", dest="out",
                       help="# output pdb", metavar="STR")

op.set_defaults(struct='peptide.pdb', inp='dA_vib.dat', out='dA_peptide.pdb')

(opts, args) = op.parse_args ()




####################
## residue based
dA_vib = np.genfromtxt(opts.inp)[:,2]


###########
## making the right pdb file
pdb_f = open(opts.struct, 'r')
lines = pdb_f.readlines()
nlines = len(lines)
print nlines
pdb_f.close()

out_f = open(opts.out, 'w+')

for lnum,l in enumerate(lines):
    vals = l.strip().split()
    if vals[0]!='ATOM' or (len(vals) < 10):
        out_f.write(l)
    elif int(vals[1])-1 < len(dA_vib):
        #print vals
        if len(vals[1])==1:
            out_str = "%s      %s" % (vals[0], vals[1])
        elif len(vals[1])==2:
            out_str = "%s     %s" % (vals[0], vals[1])
        elif len(vals[1])==3:
            out_str = "%s    %s" % (vals[0], vals[1])
        else:
            out_str = "%s   %s" % (vals[0], vals[1])
        if len(vals[2])==1:
            out_str +="  %s   %s" % (vals[2], vals[3])
        elif len(vals[2])==2:
            out_str +="  %s  %s" % (vals[2], vals[3])
        elif len(vals[2])==3:
            out_str +="  %s %s" % (vals[2], vals[3])
        else:
            out_str +=" %s %s"  % (vals[2], vals[3])
        if len(vals[4])==1:
            out_str += "     %s" % (vals[4])
        elif len(vals[4])==2:
            out_str += "    %s" % (vals[4])
        else:
            out_str += "   %s" % (vals[4])
        # now xyz
        for i in range(12 - len(vals[5])):
            out_str += " "
        #
        out_str += vals[5]
        for i in range(8 - len(vals[6])):
            out_str += " "
        #
        out_str += vals[6]
        for i in range(8 - len(vals[7])):
            out_str += " "
        #
        out_str += vals[7]
        dA_str=" %2.2f" % (dA_vib[int(vals[1])-1])
        #print dA_str
        for i in range(6 - len(dA_str)):
            out_str += " "
        #
        out_str += dA_str
        out_str += "  0.00           "
        out_str += "\n"
        out_f.write(out_str)

out_f.close()



