%%% Plot currently selected parameters in plot.ly
%%%
%%% mode 1 is normal 2d histogram
%%% mode 2 uses kernel density estimation to smooth the data

function to_plotly2d(mode)
%%% this function reads all relevant data directly from the GUI of
%%% BurstBrowser
global BurstData BurstMeta UserValues
if nargin == 0
    mode = 1;
end
h = guidata(findobj('Tag','BurstBrowser'));
file = BurstMeta.SelectedFile;
x = h.ParameterListX.String{h.ParameterListX.Value};
y = h.ParameterListY.String{h.ParameterListY.Value};
names = {x,y};
x = strcmp(BurstData{file}.NameArray,x);
y = strcmp(BurstData{file}.NameArray,y);
bins = [UserValues.BurstBrowser.Display.NumberOfBinsX,UserValues.BurstBrowser.Display.NumberOfBinsY];
lim = {h.axes_general.XLim,h.axes_general.YLim};
plotly_burst(BurstData{file}.DataCut(:,x),BurstData{file}.DataCut(:,y),names, bins, lim, mode);

function plotly_burst(x_data,y_data, names, bins, lim,type)
%signin('anders.barth', 'api_key')

%%% set default number of bins
if nargin < 3
    bins = [50,50];
end
%%% get the range
if ~exist('lim','var')
    lim{1} = [min(x_data), max(x_data)];
    lim{2} = [min(y_data), max(y_data)];
end
lim{1} = sort(lim{1});
lim{2} = sort(lim{2});

if ~exist('type','var')
    type = 1;
end

xbins = struct(...
        'end', lim{1}(2), ...
        'size', (lim{1}(2)-lim{1}(1))/(bins(1)+1), ...
        'start', lim{1}(1));
ybins = struct(...
        'end', lim{2}(2), ...
        'size', (lim{2}(2)-lim{2}(1))/(bins(2)+1), ...
        'start', lim{2}(1));
        
switch type
    case 1
        % Get this figure: fig = getplotlyfig('jackp', 3880)
        % Get this figure's data: fig = getplotlyfig('jackp', 3880); fig.data
        % Add data to this figure: plotly([1, 2], [2, 3], struct('filename', '2dhistogram-contour-subplots', 'fileopt', 'extend'))
        % Get y data of first trace: fig = getplotlyfig('jackp', 3880); y1 = fig.data{1}.y

        % Get figure documentation: https://plot.ly/matlab/get-requests/
        % Add data documentation: https://plot.ly/matlab/file-options/

        % You can reproduce this figure in MATLAB with the following code!

        % Learn about API authentication here: https://plot.ly/matlab/getting-started
        % Find your api_key here: https://plot.ly/settings/api
        trace1 = struct(...
          'x', x_data,...
          'y', y_data,...
          'marker', struct(...
            'color', 'rgb(255, 255, 255)', ...
            'line', struct('width', 0.5), ...
            'opacity', 0.4, ...
            'size', 4), ...
          'mode', 'markers', ...
          'name', 'points', ...
          'opacity', 0.75, ...
          'type', 'scatter', ...
          'uid', 'eb94b3');
        trace2 = struct(...
          'x', x_data,...
          'y', y_data,...
          'autocolorscale', false, ...
          'colorscale', { { {0, 'rgb(8, 29, 88)'},{0.125, 'rgb(37, 52, 148)'},{0.25, 'rgb(34, 94, 168)'},{0.375, 'rgb(29, 145, 192)'},{0.5, 'rgb(65, 182, 196)'},{0.625, 'rgb(127, 205, 187)'},{0.75, 'rgb(199, 233, 180)'},{0.875, 'rgb(237, 248, 217)'},{1, 'rgb(255, 255, 217)'} } }, ...
          'contours', struct(...
            'coloring', 'fill', ...
            'showlines', true, ...
            'size', 5, ...
            'start', 5), ...
          'name', 'density', ...
          'ncontours', 20, ...
          'reversescale', false, ...
          'showscale', false, ...
          'type', 'histogram2dcontour', ...
          'uid', 'b20cd7', ...
          'xbins',xbins, ...
          'ybins',ybins, ...
          'zmin', 0);
        trace3 = struct(...
          'x', x_data,...
          'marker', struct('color', 'rgb(31, 119, 180)'), ...
          'name', 'x density', ...
          'type', 'histogram', ...
          'uid', '70efa7', ...
          'xbins',xbins, ...
          'yaxis', 'y2');
        trace4 = struct(...
          'y', y_data,...
          'marker', struct('color', 'rgb(33, 113, 181)'), ...
          'name', 'y density', ...
          'type', 'histogram', ...
          'uid', '73ca31', ...
          'xaxis', 'x2', ...
          'ybins', ybins);
        data = {trace1, trace2, trace3, trace4};
        layout = struct(...
          'autosize', false, ...
          'bargap', 0, ...
          'height', 700, ...
          'hovermode', 'closest', ...
          'margin', struct('t', 50), ...
          'paper_bgcolor', 'rgb(249, 249, 249)', ...
          'plot_bgcolor', 'rgb(249, 249, 249)', ...
          'showlegend', false, ...
          'title', '', ...
          'width', 800, ...
          'xaxis', struct(...
            'autorange', false, ...
            'domain', [0, 0.85], ...
            'range', lim{1}, ...
            'showgrid', false, ...
            'title', names{1}, ...
            'type', 'linear', ...
            'zeroline', false), ...
          'xaxis2', struct(...
            'autorange', true, ...
            'domain', [0.85, 1], ...
            'range', lim{1}, ...
            'showgrid', false, ...
            'title', '', ...
            'type', 'linear', ...
            'zeroline', false), ...
          'yaxis', struct(...
            'autorange', false, ...
            'domain', [0, 0.85], ...
            'range', lim{2}, ...
            'showgrid', false, ...
            'title',names{2}, ...
            'type', 'linear', ...
            'zeroline', false), ...
          'yaxis2', struct(...
            'autorange', true, ...
            'domain', [0.85, 1], ...
            'range', lim{2}, ...
            'showgrid', false, ...
            'title', '', ...
            'type', 'linear', ...
            'zeroline', false));
    case 2
        % Get this figure: fig = getplotlyfig('jackp', 15667)
        % Get this figure's data: fig = getplotlyfig('jackp', 15667); fig.data
        % Add data to this figure: plotly([1, 2], [2, 3], struct('filename', 'pandas-2d-density-plot (copy) (1)', 'fileopt', 'extend'))
        % Get y data of first trace: fig = getplotlyfig('jackp', 15667); y1 = fig.data{1}.y

        % Get figure documentation: https://plot.ly/matlab/get-requests/
        % Add data documentation: https://plot.ly/matlab/file-options/

        % You can reproduce this figure in MATLAB with the following code!

        % Learn about API authentication here: https://plot.ly/matlab/getting-started
        % Find your api_key here: https://plot.ly/settings/api
        
        bins = min(bins); %%% can only use one bin
        %%% generate kernel densities for 1D projections
        [~,H, xbins_hist, ybins_hist] = kde2d([x_data y_data],4*bins,[lim{1}(1) lim{2}(1)],[lim{1}(2), lim{2}(2)]);
        xbins_hist = xbins_hist(1,:);
        ybins_hist = ybins_hist(:,1);
        H = H./max(H(:));
        
        trace0 = struct(...
          'x', x_data,...
          'y', y_data,...
          'marker', struct(...
            'color', 'rgb(0, 0, 0)', ...
            'line', struct('width', 0.5), ...
            'opacity', 0.75, ...
            'size', 3), ...
          'mode', 'markers', ...
          'name', 'points', ...
          'opacity', 0.75, ...
          'type', 'scatter', ...
          'uid', 'eb94b3');
        trace1 = struct(...
          'x', xbins_hist,...
          'y', ybins_hist,...
          'z',H,...
          'colorscale', { { {0, 'rgb(247,251,255)'},{0.125, 'rgb(222,235,247)'},{0.25, 'rgb(198,219,239)'},{0.375, 'rgb(158,202,225)'},{0.5, 'rgb(107,174,214)'},{0.625, 'rgb(66,146,198)'},{0.75, 'rgb(33,113,181)'},{0.875, 'rgb(8,81,156)'},{1, 'rgb(8,48,107)'} } }, ...
          'contours', struct(...
            'coloring', 'fill', ...
            'showlines', false, ...
            'start', max(H(:))*0.05,...
            'end',max(H(:)),...
            'size',max(H(:))*0.05), ...
          'name', 'density', ...
          'showscale', false, ...
          'type', 'contour', ...
          'uid', '0a0195');
        trace2 = struct(...
          'x', x_data,...
          'histnorm', 'probability density', ...
          'marker', struct('color', 'rgb(217, 217, 217)'), ...
          'name', 'x density', ...
          'nbinsx', bins, ...
          'type', 'histogram', ...
          'uid', 'c9fc6f', ...
          'xbins', xbins, ...
          'yaxis', 'y2');
        trace3 = struct(...
          'x', xbins_hist,...
          'y', sum(H,1)./sum(sum(H,1))./min(diff(xbins_hist)),...
          'fill', 'tonexty', ...
          'line', struct('color', 'rgb(31, 119, 180)'), ...
          'name', 'y', ...
          'type', 'scatter', ...
          'uid', 'b5d78a', ...
          'yaxis', 'y2');
        trace4 = struct(...
          'y', y_data,...
          'histnorm', 'probability density', ...
          'marker', struct('color', 'rgb(217, 217, 217)'), ...
          'name', 'y density', ...
          'nbinsy', bins, ...
          'type', 'histogram', ...
          'uid', '8656d0', ...
          'xaxis', 'x2', ...
          'ybins', ybins);
        trace5 = struct(...
          'y', ybins_hist,...
          'x', sum(H,2)./sum(sum(H,2))./min(diff(ybins_hist)),...
          'fill', 'tonextx', ...
          'line', struct('color', 'rgb(31, 119, 180)'), ...
          'name', 'trace4', ...
          'type', 'scatter', ...
          'uid', '7a330b', ...
          'xaxis', 'x2');
        data = {trace0,trace1, trace2, trace3, trace4, trace5};
        layout = struct(...
          'autosize', true, ...
          'bargap', 0, ...
          'height', 1000, ...
          'hovermode', 'closest', ...
          'margin', struct(...
            'r', 40, ...
            't', 40), ...
          'showlegend', false, ...
          'title', '', ...
          'width', 1000, ...
          'xaxis', struct(...
            'autorange', false, ...
            'domain', [0, 0.746], ...
            'linecolor', '#444', ...
            'linewidth', 2, ...
            'mirror', true, ...
            'range', lim{1}, ...
            'showgrid', false, ...
            'showline', true, ...
            'title', names{1}, ...
            'type', 'linear', ...
            'zeroline', false), ...
          'xaxis2', struct(...
            'autorange', true, ...
            'domain', [0.75, 1], ...
            'range', lim{1}, ...
            'showgrid', false, ...
            'showticklabels', false, ...
            'ticks', '', ...
            'title', '', ...
            'type', 'linear', ...
            'zeroline', false), ...
          'yaxis', struct(...
            'autorange', false, ...
            'domain', [0, 0.746], ...
            'linecolor', '#444', ...
            'linewidth', 2, ...
            'mirror', true, ...
            'range', lim{2}, ...
            'showgrid', false, ...
            'showline', true, ...
            'title', names{2}, ...
            'type', 'linear', ...
            'zeroline', false), ...
          'yaxis2', struct(...
            'autorange', true, ...
            'domain', [0.75, 1], ...
            'range', lim{2}, ...
            'showgrid', false, ...
            'showticklabels', false, ...
            'ticks', '', ...
            'title', '', ...
            'type', 'linear', ...
            'zeroline', false));
end

p = plotlyfig;
p.data = data;
p.layout = layout;
p.PlotOptions.FileName = 'basic-offline';
% Create a standalone HTML file
html_file = plotlyoffline(p);
delete(findobj('Name',p.PlotOptions.FileName));
web(html_file);