/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.net.HTTPAuthProvider;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethodStream;
import ucar.nc2.util.net.HTTPSession;

@NotThreadSafe
public class HTTPMethod {
    static HashMap<String, Object> globalparams = new HashMap();
    HTTPSession session = null;
    boolean localsession = false;
    HttpMethodBase method = null;
    String legalurl = null;
    List<Header> headers = new ArrayList<Header>();
    HashMap<String, Object> params = new HashMap();
    HttpState context = null;
    RequestEntity content = null;
    HTTPSession.Methods methodclass = null;
    Part[] multiparts = null;
    HTTPMethodStream methodstream = null;
    boolean closed = false;

    public static HTTPMethod Get(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Get, session, null);
    }

    public static HTTPMethod Head(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Head, session, null);
    }

    public static HTTPMethod Put(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Put, session, null);
    }

    public static HTTPMethod Post(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Post, session, null);
    }

    public static HTTPMethod Options(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Options, session, null);
    }

    public static HTTPMethod Get(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Get, session, legalurl);
    }

    public static HTTPMethod Head(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Head, session, legalurl);
    }

    public static HTTPMethod Put(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Put, session, legalurl);
    }

    public static HTTPMethod Post(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Post, session, legalurl);
    }

    public static HTTPMethod Options(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Options, session, legalurl);
    }

    public static HTTPMethod Get(String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Get, legalurl);
    }

    public static HTTPMethod Head(String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Head, legalurl);
    }

    public static HTTPMethod Put(String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Put, legalurl);
    }

    public static HTTPMethod Post(String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Post, legalurl);
    }

    public static HTTPMethod Options(String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Options, legalurl);
    }

    public static HTTPMethod Get() throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Get);
    }

    public static HTTPMethod Head() throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Head);
    }

    public static HTTPMethod Put() throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Put);
    }

    public static HTTPMethod Post() throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Post);
    }

    public static HTTPMethod Options() throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Options);
    }

    public static synchronized void setGlobalParameter(String name, Object value) {
        globalparams.put(name, value);
    }

    public static int getRetryCount() {
        return RetryHandler.getRetries();
    }

    public static void setRetryCount(int count) {
        RetryHandler.setRetries(count);
    }

    public HTTPMethod(HTTPSession.Methods m) throws HTTPException {
        this(m, null, null);
    }

    public HTTPMethod(HTTPSession.Methods m, String url) throws HTTPException {
        this(m, null, url);
    }

    public HTTPMethod(HTTPSession.Methods m, HTTPSession session, String url) throws HTTPException {
        if (session == null) {
            session = new HTTPSession();
            this.localsession = true;
        }
        this.session = session;
        if (url == null) {
            url = session.getURL();
        }
        if (url != null) {
            url = HTTPSession.removeprincipal(url);
        }
        this.legalurl = url;
        this.session.addMethod(this);
        this.methodclass = m;
    }

    HttpMethodBase create() {
        PutMethod method = null;
        String urlencoded = EscapeStrings.escapeURL(this.legalurl);
        switch (this.methodclass) {
            case Put: {
                method = new PutMethod(urlencoded);
                break;
            }
            case Post: {
                method = new PostMethod(urlencoded);
                break;
            }
            case Get: {
                method = new GetMethod(urlencoded);
                break;
            }
            case Head: {
                method = new HeadMethod(urlencoded);
                break;
            }
            case Options: {
                method = new OptionsMethod(urlencoded);
                break;
            }
        }
        if (method != null) {
            method.setFollowRedirects(true);
            method.setDoAuthentication(true);
        }
        return method;
    }

    void setcontent() {
        switch (this.methodclass) {
            case Put: {
                if (this.content == null) break;
                ((PutMethod)this.method).setRequestEntity(this.content);
                break;
            }
            case Post: {
                if (this.multiparts != null && this.multiparts.length > 0) {
                    MultipartRequestEntity mre = new MultipartRequestEntity(this.multiparts, this.method.getParams());
                    ((PostMethod)this.method).setRequestEntity((RequestEntity)mre);
                    break;
                }
                if (this.content == null) break;
                ((PostMethod)this.method).setRequestEntity(this.content);
                break;
            }
        }
        this.content = null;
        this.multiparts = null;
    }

    public int execute(String url) throws HTTPException {
        this.legalurl = url;
        return this.execute();
    }

    public int execute() throws HTTPException {
        if (this.closed) {
            throw new HTTPException("HTTPMethod: attempt to execute closed method");
        }
        if (this.legalurl == null) {
            throw new HTTPException("HTTPMethod: no url specified");
        }
        if (!this.localsession && !this.sessionCompatible(this.legalurl)) {
            throw new HTTPException("HTTPMethod: session incompatible url: " + this.legalurl);
        }
        if (this.method != null) {
            this.method.releaseConnection();
        }
        this.method = this.create();
        try {
            HttpMethodParams hmp;
            if (this.headers.size() > 0) {
                for (Header h : this.headers) {
                    this.method.addRequestHeader(h);
                }
            }
            if (globalparams != null) {
                hmp = this.method.getParams();
                for (String key : globalparams.keySet()) {
                    hmp.setParameter(key, globalparams.get(key));
                }
            }
            if (this.params != null) {
                hmp = this.method.getParams();
                for (String key : this.params.keySet()) {
                    hmp.setParameter(key, this.params.get(key));
                }
            }
            this.method.getParams().setParameter("http.method.retry-handler", (Object)new RetryHandler());
            this.setcontent();
            HTTPMethod.setAuthentication(this.session, this);
            URL hack = new URL(this.legalurl);
            Protocol handler = HTTPSession.getProtocol(hack.getProtocol(), hack.getPort());
            HostConfiguration hc = this.session.sessionClient.getHostConfiguration();
            hc = new HostConfiguration(hc);
            hc.setHost(hack.getHost(), hack.getPort(), handler);
            this.session.sessionClient.executeMethod(hc, (HttpMethod)this.method);
            int code = this.getStatusCode();
            return code;
        }
        catch (Exception ie) {
            throw new HTTPException(ie);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.methodstream != null) {
            try {
                this.methodstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.methodstream = null;
        }
        if (this.method != null) {
            this.method.releaseConnection();
            this.method = null;
        }
        this.session.removeMethod(this);
        if (this.localsession && this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void setContext(HttpState cxt) {
        this.session.setContext(cxt);
    }

    public HttpState getContext() {
        return this.session.getContext();
    }

    public int getStatusCode() {
        return this.method == null ? 0 : this.method.getStatusCode();
    }

    public String getStatusLine() {
        return this.method == null ? null : this.method.getStatusLine().toString();
    }

    public String getRequestLine() {
        return "getrequestline not implemented";
    }

    public String getPath() {
        try {
            return this.method == null ? null : this.method.getURI().toString();
        }
        catch (URIException e) {
            return null;
        }
    }

    public boolean canHoldContent() {
        if (this.method == null) {
            return false;
        }
        return !(this.method instanceof HeadMethod);
    }

    public InputStream getResponseBodyAsStream() {
        return this.getResponseAsStream();
    }

    public InputStream getResponseAsStream() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        if (this.methodstream != null) {
            HTTPSession.log.warn("HTTPMethod.getResponseBodyAsStream: Getting method stream multiple times");
        } else {
            HTTPMethodStream stream = null;
            try {
                if (this.method == null) {
                    return null;
                }
                stream = new HTTPMethodStream(this.method.getResponseBodyAsStream(), this);
            }
            catch (Exception e) {
                stream = null;
            }
            this.methodstream = stream;
        }
        return this.methodstream;
    }

    public byte[] getResponseAsBytes() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        byte[] content = null;
        try {
            content = this.method.getResponseBody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public byte[] getResponseAsBytes(int maxsize) {
        byte[] content = this.getResponseAsBytes();
        if (content != null && content.length > maxsize) {
            byte[] limited = new byte[maxsize];
            System.arraycopy(content, 0, limited, 0, maxsize);
            content = limited;
        }
        return content;
    }

    public String getResponseAsString(String charset) {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        String content = null;
        try {
            content = this.method.getResponseBodyAsString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public String getResponseAsString() {
        return this.getResponseAsString("UTF-8");
    }

    public void setMethodHeaders(List<Header> headers) throws HTTPException {
        try {
            for (Header h : headers) {
                this.headers.add(h);
            }
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public void setRequestHeader(String name, String value) throws HTTPException {
        this.setRequestHeader(new Header(name, value));
    }

    public void setRequestHeader(Header h) throws HTTPException {
        try {
            this.headers.add(h);
        }
        catch (Exception e) {
            throw new HTTPException("cause", e);
        }
    }

    public Header getRequestHeader(String name) {
        if (this.method == null) {
            return null;
        }
        try {
            return this.method.getRequestHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getRequestHeaders() {
        if (this.method == null) {
            return null;
        }
        try {
            Header[] hs = this.method.getRequestHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header getResponseHeader(String name) {
        try {
            return this.method.getResponseHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header getResponseHeaderdmh(String name) {
        try {
            Header[] headers;
            for (Header h : headers = this.getResponseHeaders()) {
                if (!h.getName().equals(name)) continue;
                return h;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseHeaders() {
        try {
            Header[] hs = this.method.getResponseHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseFooters() {
        try {
            Header[] hs = this.method.getResponseFooters();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRequestParameter(String name, Object value) {
        this.params.put(name, value);
    }

    public Object getMethodParameter(String key) {
        if (this.method == null) {
            return null;
        }
        return this.method.getParams().getParameter(key);
    }

    public HttpMethodParams getMethodParameters() {
        if (this.method == null) {
            return null;
        }
        return this.method.getParams();
    }

    public Object getResponseParameter(String name) {
        if (this.method == null) {
            return null;
        }
        return this.method.getParams().getParameter(name);
    }

    public void setRequestContentAsString(String content) throws HTTPException {
        try {
            this.content = new StringRequestEntity(content, "application/text", "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setMultipartRequest(Part[] parts) throws HTTPException {
        this.multiparts = new Part[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.multiparts[i] = parts[i];
        }
    }

    public String getCharSet() {
        return "UTF-8";
    }

    public String getName() {
        return this.method == null ? null : this.method.getName();
    }

    public String getURL() {
        return this.method == null ? null : this.method.getPath().toString();
    }

    public String getEffectiveVersion() {
        String ver = null;
        if (this.method != null) {
            ver = this.method.getEffectiveVersion().toString();
        }
        return ver;
    }

    public String getProtocolVersion() {
        return this.getEffectiveVersion();
    }

    public String getSoTimeout() {
        return this.method == null ? null : "" + this.method.getParams().getSoTimeout();
    }

    public String getVirtualHost() {
        return this.method == null ? null : this.method.getParams().getVirtualHost();
    }

    public String getStatusText() {
        return this.getStatusLine();
    }

    public static Enumeration getAllowedMethods() {
        Enumeration e = new OptionsMethod().getAllowedMethods();
        return e;
    }

    public void setFollowRedirects(boolean tf) {
    }

    public String getResponseCharSet() {
        return "UTF-8";
    }

    public HTTPSession getSession() {
        return this.session;
    }

    public boolean isSessionLocal() {
        return this.localsession;
    }

    public HttpMethodBase getMethod() {
        return this.method;
    }

    public boolean hasStreamOpen() {
        return this.methodstream != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    boolean sessionCompatible(String other) {
        String sessionurl = HTTPSession.getCanonicalURL(this.session.getURL());
        if (sessionurl == null) {
            return true;
        }
        other = HTTPSession.getCanonicalURL(other);
        return HTTPAuthStore.compatibleURL(sessionurl, other);
    }

    private static synchronized void setAuthentication(HTTPSession session, HTTPMethod method) {
        String url = session.getURL();
        if (url == null) {
            url = "";
        }
        HTTPAuthProvider cp = new HTTPAuthProvider(url, method);
        session.sessionClient.getParams().setParameter("http.authentication.credential-provider", (Object)cp);
        HttpConnectionManagerParams hcp = session.sessionClient.getHttpConnectionManager().getParams();
        hcp.setParameter("http.authentication.credential-provider", (Object)cp);
    }

    public static class RetryHandler
    extends DefaultHttpMethodRetryHandler {
        static final int DFALTRETRIES = 5;
        static int retries = 5;
        static boolean verbose = false;

        public RetryHandler() {
            super(retries, false);
        }

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            if (verbose) {
                HTTPSession.log.debug(String.format("Retry: count=%d exception=%s\n", executionCount, exception.toString()));
            }
            return super.retryMethod(method, exception, executionCount);
        }

        public static int getRetries() {
            return retries;
        }

        public static void setRetries(int retries) {
            if (retries > 0) {
                RetryHandler.retries = retries;
            }
        }

        public static boolean getVerbose() {
            return verbose;
        }

        public static void setVerbose(boolean tf) {
            verbose = tf;
        }
    }
}

