/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFileOS;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.cache.FileFactory;

public abstract class Aggregation {
    protected static TypicalDataset typicalDatasetMode;
    protected static Logger logger;
    protected static DiskCache2 diskCache2;
    protected static Executor executor;
    protected static boolean debug;
    protected static boolean debugOpenFile;
    protected static boolean debugSyncDetail;
    protected static boolean debugProxy;
    protected static boolean debugRead;
    protected static boolean debugDateParse;
    protected static boolean debugConvert;
    protected NetcdfDataset ncDataset;
    protected Type type;
    protected Object spiObject;
    protected List<Dataset> explicitDatasets = new ArrayList<Dataset>();
    protected List<Dataset> datasets = new ArrayList<Dataset>();
    protected MFileCollectionManager datasetManager;
    protected boolean cacheDirty = true;
    protected String dimName;
    private Element mergeNcml = null;
    protected String dateFormatMark;
    protected boolean isDate = false;
    protected DateFormatter dateFormatter = new DateFormatter();

    public static void setPersistenceCache(DiskCache2 dc) {
        diskCache2 = dc;
    }

    public static void setExecutor(Executor exec) {
        executor = exec;
    }

    public static void setTypicalDatasetMode(String mode) {
        if (mode.equalsIgnoreCase("random")) {
            typicalDatasetMode = TypicalDataset.RANDOM;
        } else if (mode.equalsIgnoreCase("latest")) {
            typicalDatasetMode = TypicalDataset.LATEST;
        } else if (mode.equalsIgnoreCase("penultimate")) {
            typicalDatasetMode = TypicalDataset.PENULTIMATE;
        } else if (mode.equalsIgnoreCase("first")) {
            typicalDatasetMode = TypicalDataset.FIRST;
        } else {
            logger.error("Unknown setTypicalDatasetMode= " + mode);
        }
    }

    protected Aggregation(NetcdfDataset ncd, String dimName, Type type, String recheckS) {
        this.ncDataset = ncd;
        this.dimName = dimName;
        this.type = type;
        String name = ncd.getLocation();
        if (name == null) {
            name = "Agg-" + Integer.toString(ncd.hashCode());
        }
        this.datasetManager = MFileCollectionManager.openWithRecheck(name, recheckS);
    }

    public void addExplicitDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, FileFactory reader) {
        Dataset nested = this.makeDataset(cacheName, location, id, ncoordS, coordValueS, sectionSpec, null, reader);
        this.explicitDatasets.add(nested);
    }

    public void addDataset(Dataset nested) {
        this.explicitDatasets.add(nested);
    }

    public void addDatasetScan(Element crawlableDatasetElement, String dirName, String suffix, String regexpPatternString, String dateFormatMark, Set<NetcdfDataset.Enhance> enhanceMode, String subdirs, String olderThan) {
        this.datasetManager.addDirectoryScan(dirName, suffix, regexpPatternString, subdirs, olderThan, enhanceMode);
        this.dateFormatMark = dateFormatMark;
        if (dateFormatMark != null) {
            this.isDate = true;
            if (this.type == Type.joinExisting) {
                this.type = Type.joinExistingOne;
            }
            DateExtractorFromName dateExtractor = dateFormatMark == null ? null : new DateExtractorFromName(dateFormatMark, true);
            this.datasetManager.setDateExtractor(dateExtractor);
        }
    }

    public void addCollection(String spec, String olderThan) throws IOException {
        this.datasetManager = MFileCollectionManager.open(spec, olderThan, null);
    }

    public void setModifications(Element ncmlMods) {
        this.mergeNcml = ncmlMods;
    }

    public Type getType() {
        return this.type;
    }

    public String getDimensionName() {
        return this.dimName;
    }

    protected String getLocation() {
        return this.ncDataset.getLocation();
    }

    public void close() throws IOException {
        this.persistWrite();
        this.closeDatasets();
    }

    public synchronized boolean syncExtend() throws IOException {
        return this.datasetManager.isScanNeeded() && this._sync();
    }

    public synchronized boolean sync() throws IOException {
        return this.datasetManager.isScanNeeded() && this._sync();
    }

    private boolean _sync() throws IOException {
        if (!this.datasetManager.scan(true)) {
            return false;
        }
        this.cacheDirty = true;
        this.closeDatasets();
        this.makeDatasets(null);
        this.rebuildDataset();
        this.ncDataset.finish();
        if (this.ncDataset.getEnhanceMode().contains((Object)NetcdfDataset.Enhance.CoordSystems)) {
            this.ncDataset.clearCoordinateSystems();
            this.ncDataset.enhance(this.ncDataset.getEnhanceMode());
            this.ncDataset.finish();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileTypeId() {
        Dataset ds = null;
        NetcdfFile ncfile = null;
        try {
            ds = this.getTypicalDataset();
            ncfile = ds.acquireFile(null);
            String string = ncfile.getFileTypeId();
            return string;
        }
        catch (Exception e) {
            logger.error("failed to open " + ds);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close(ncfile);
                }
                catch (IOException e) {
                    logger.error("failed to close " + ds);
                }
            }
        }
        return "N/A";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileTypeDescription() {
        Dataset ds = null;
        NetcdfFile ncfile = null;
        try {
            ds = this.getTypicalDataset();
            ncfile = ds.acquireFile(null);
            String string = ncfile.getFileTypeDescription();
            return string;
        }
        catch (Exception e) {
            logger.error("failed to open " + ds);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close(ncfile);
                }
                catch (IOException e) {
                    logger.error("failed to close " + ds);
                }
            }
        }
        return "N/A";
    }

    protected abstract void buildNetcdfDataset(CancelTask var1) throws IOException;

    protected abstract void rebuildDataset() throws IOException;

    public void persistWrite() throws IOException {
    }

    protected void persistRead() {
    }

    protected void closeDatasets() throws IOException {
    }

    public void getDetailInfo(Formatter f) {
        f.format("  Type=%s%n", new Object[]{this.type});
        f.format("  dimName=%s%n", this.dimName);
        f.format("  Datasets%n", new Object[0]);
        for (Dataset ds : this.datasets) {
            ds.show(f);
        }
    }

    public void finish(CancelTask cancelTask) throws IOException {
        this.datasetManager.scan(true);
        this.cacheDirty = true;
        this.closeDatasets();
        this.makeDatasets(cancelTask);
        this.buildNetcdfDataset(cancelTask);
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        this.datasets = new ArrayList<Dataset>();
        for (MFile cd : this.datasetManager.getFiles()) {
            this.datasets.add(this.makeDataset(cd));
        }
        Collections.sort(this.datasets);
        for (Dataset dataset : this.explicitDatasets) {
            this.datasets.add(dataset);
        }
        HashSet<String> dset = new HashSet<String>(2 * this.datasets.size());
        for (Dataset dataset : this.datasets) {
            if (dset.contains(dataset.cacheLocation)) {
                logger.warn("Duplicate dataset in aggregation = " + dataset.cacheLocation);
            }
            dset.add(dataset.cacheLocation);
        }
        if (this.datasets.size() == 0) {
            throw new IllegalStateException("There are no datasets in the aggregation " + this.datasetManager);
        }
    }

    protected Dataset getTypicalDataset() throws IOException {
        List<Dataset> nestedDatasets = this.getDatasets();
        int n = nestedDatasets.size();
        if (n == 0) {
            throw new FileNotFoundException("No datasets in this aggregation");
        }
        int select = typicalDatasetMode == TypicalDataset.LATEST ? n - 1 : (typicalDatasetMode == TypicalDataset.PENULTIMATE ? (n < 2 ? 0 : n - 2) : (typicalDatasetMode == TypicalDataset.FIRST ? 0 : (n < 2 ? 0 : new Random().nextInt(n))));
        return nestedDatasets.get(select);
    }

    protected Dataset makeDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
        return new Dataset(cacheName, location, id, enhance, reader);
    }

    protected Dataset makeDataset(MFile dset) {
        return new Dataset(dset);
    }

    protected void setDatasetAcquireProxy(Dataset typicalDataset, NetcdfDataset newds) throws IOException {
        DatasetProxyReader proxy = new DatasetProxyReader(typicalDataset);
        this.setDatasetAcquireProxy(proxy, newds.getRootGroup());
    }

    protected void setDatasetAcquireProxy(DatasetProxyReader proxy, Group g) throws IOException {
        for (Variable v : g.getVariables()) {
            if (v.getProxyReader() != v) {
                if (!debugProxy) continue;
                System.out.println(" debugProxy: hasProxyReader " + v.getFullName());
                continue;
            }
            if (v.isCaching()) {
                v.setCachedData(v.read());
                continue;
            }
            v.setProxyReader(proxy);
            if (!debugProxy) continue;
            System.out.println(" debugProxy: set proxy on " + v.getFullName());
        }
        for (Group nested : g.getGroups()) {
            this.setDatasetAcquireProxy(proxy, nested);
        }
    }

    protected Variable findVariable(NetcdfFile ncfile, Variable mainV) {
        Variable v = ncfile.findVariable(mainV.getFullNameEscaped());
        if (v == null) {
            VariableEnhanced ve = (VariableEnhanced)((Object)mainV);
            v = ncfile.findVariable(ve.getOriginalName());
        }
        return v;
    }

    static {
        logger = LoggerFactory.getLogger(Aggregation.class);
        diskCache2 = null;
        debug = false;
        debugOpenFile = false;
        debugSyncDetail = false;
        debugProxy = false;
        debugRead = false;
        debugDateParse = false;
        debugConvert = false;
    }

    protected class DatasetProxyReader
    implements ProxyReader {
        Dataset dataset;

        DatasetProxyReader(Dataset dataset) {
            this.dataset = dataset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Array reallyRead(Variable mainV, CancelTask cancelTask) throws IOException {
            NetcdfFile ncfile = null;
            try {
                ncfile = this.dataset.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable proxyV = Aggregation.this.findVariable(ncfile, mainV);
                Array array = proxyV.read();
                return array;
            }
            finally {
                this.dataset.close(ncfile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Array reallyRead(Variable mainV, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            NetcdfFile ncfile = null;
            try {
                ncfile = this.dataset.acquireFile(cancelTask);
                Variable proxyV = Aggregation.this.findVariable(ncfile, mainV);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Array array = proxyV.read(section);
                return array;
            }
            finally {
                this.dataset.close(ncfile);
            }
        }
    }

    public class Dataset
    implements Comparable {
        MFile mfile;
        protected String id;
        protected String cacheLocation;
        protected FileFactory reader;
        protected Set<NetcdfDataset.Enhance> enhance;
        protected Object extraInfo;

        protected Dataset(MFile mfile) {
            this.mfile = mfile;
            this.cacheLocation = mfile.getPath();
            this.enhance = (Set)mfile.getAuxInfo();
        }

        protected Dataset(String cacheLocation, String location, String id, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
            this.mfile = MFileOS.getExistingFile(location);
            this.cacheLocation = cacheLocation;
            this.id = id;
            this.reader = reader;
        }

        public String getLocation() {
            return this.mfile == null ? this.cacheLocation : this.mfile.getPath();
        }

        public MFile getMFile() {
            return this.mfile;
        }

        public String getCacheLocation() {
            return this.cacheLocation;
        }

        public String getId() {
            if (this.id != null) {
                return this.id;
            }
            if (this.mfile != null) {
                return this.mfile.getPath();
            }
            return Integer.toString(this.hashCode());
        }

        public NetcdfFile acquireFile(CancelTask cancelTask) throws IOException {
            NetcdfDataset ds;
            if (debugOpenFile) {
                System.out.println(" try to acquire " + this.cacheLocation);
            }
            long start = System.currentTimeMillis();
            NetcdfFile ncfile = NetcdfDataset.acquireFile(this.reader, null, this.cacheLocation, -1, cancelTask, Aggregation.this.spiObject);
            if (Aggregation.this.mergeNcml != null) {
                ncfile = NcMLReader.mergeNcML(ncfile, Aggregation.this.mergeNcml);
            }
            if (this.enhance == null || this.enhance.isEmpty()) {
                if (debugOpenFile) {
                    System.out.println(" acquire (no enhance) " + this.cacheLocation + " took " + (System.currentTimeMillis() - start));
                }
                return ncfile;
            }
            if (ncfile instanceof NetcdfDataset) {
                ds = (NetcdfDataset)ncfile;
                ds.enhance(this.enhance);
            } else {
                ds = new NetcdfDataset(ncfile, this.enhance);
            }
            if (debugOpenFile) {
                System.out.println(" acquire (enhance) " + this.cacheLocation + " took " + (System.currentTimeMillis() - start));
            }
            return ds;
        }

        protected void close(NetcdfFile ncfile) throws IOException {
            if (ncfile == null) {
                return;
            }
            this.cacheVariables(ncfile);
            ncfile.close();
        }

        protected void cacheVariables(NetcdfFile ncfile) throws IOException {
        }

        public void show(Formatter f) {
            f.format("   %s%n", this.mfile.getPath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(Variable mainv, CancelTask cancelTask) throws IOException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable v = this.findVariable(ncd, mainv);
                if (mainv == null || v == null) {
                    System.out.println("HEY (mainv == null)");
                }
                if (debugRead) {
                    System.out.printf("Agg.read %s from %s in %s%n", mainv.getNameAndDimensions(), v.getNameAndDimensions(), this.getLocation());
                }
                Array array = v.read();
                return array;
            }
            finally {
                this.close(ncd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
            NetcdfFile ncd = null;
            try {
                ncd = this.acquireFile(cancelTask);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable v = this.findVariable(ncd, mainv);
                if (debugRead) {
                    Section want = new Section(section);
                    System.out.printf("Agg.read(%s) %s from %s in %s%n", want, mainv.getNameAndDimensions(), v.getNameAndDimensions(), this.getLocation());
                }
                Array array = v.read(section);
                return array;
            }
            finally {
                this.close(ncd);
            }
        }

        protected Variable findVariable(NetcdfFile ncfile, Variable mainV) {
            Variable v = ncfile.findVariable(mainV.getFullNameEscaped());
            if (v == null) {
                VariableEnhanced ve = (VariableEnhanced)((Object)mainV);
                v = ncfile.findVariable(ve.getOriginalName());
            }
            return v;
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof Dataset)) {
                return false;
            }
            Dataset other = (Dataset)oo;
            return this.getLocation().equals(other.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public int compareTo(Object o) {
            Dataset other = (Dataset)o;
            return this.getLocation().compareTo(other.getLocation());
        }
    }

    protected static enum TypicalDataset {
        FIRST,
        RANDOM,
        LATEST,
        PENULTIMATE;

    }

    protected static enum Type {
        forecastModelRunCollection,
        forecastModelRunSingleCollection,
        joinExisting,
        joinExistingOne,
        joinNew,
        tiled,
        union;

    }
}

