/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import thredds.inventory.CollectionManager;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;

public class TimedCollection {
    private static final boolean debug = false;
    private final CollectionManager manager;
    private List<Dataset> datasets;
    private CalendarDateRange dateRange;

    public TimedCollection(CollectionManager manager, Formatter errlog) throws IOException {
        this.manager = manager;
        manager.scanIfNeeded();
        this.update();
    }

    public void update() {
        this.datasets = new ArrayList<Dataset>();
        for (MFile f : this.manager.getFiles()) {
            this.datasets.add(new Dataset(f));
        }
        if (this.manager.hasDateExtractor()) {
            if (this.datasets.size() == 1) {
                Dataset ds = this.datasets.get(0);
                if (ds.start != null) {
                    this.dateRange = CalendarDateRange.of(ds.start, ds.start);
                }
            } else if (this.datasets.size() > 1) {
                for (int i = 0; i < this.datasets.size() - 1; ++i) {
                    Dataset d1 = this.datasets.get(i);
                    Dataset d2 = this.datasets.get(i + 1);
                    d1.setDateRange(CalendarDateRange.of(d1.start, d2.start));
                    if (i != this.datasets.size() - 2) continue;
                    d2.setDateRange(new CalendarDateRange(d2.start, d1.getDateRange().getDurationInSecs()));
                }
                Dataset first = this.datasets.get(0);
                Dataset last = this.datasets.get(this.datasets.size() - 1);
                this.dateRange = CalendarDateRange.of(first.getDateRange().getStart(), last.getDateRange().getEnd());
            }
        }
    }

    private TimedCollection(TimedCollection from, CalendarDateRange want) {
        this.manager = from.manager;
        this.datasets = new ArrayList<Dataset>(from.datasets.size());
        for (Dataset d : from.datasets) {
            if (!want.intersects(d.getDateRange())) continue;
            this.datasets.add(d);
        }
        this.dateRange = want;
    }

    public Dataset getPrototype() {
        int idx = this.manager.getProtoIndex(this.datasets.size());
        return this.datasets.get(idx);
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public TimedCollection subset(CalendarDateRange range) {
        return new TimedCollection(this, range);
    }

    public CalendarDateRange getDateRange() {
        return this.dateRange;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CollectionManager{%n", new Object[0]);
        for (Dataset d : this.datasets) {
            f.format(" %s%n", d);
        }
        f.format("}%n", new Object[0]);
        return f.toString();
    }

    private static void doit(String spec, Formatter errlog) throws IOException {
        MFileCollectionManager dcm = MFileCollectionManager.open(spec, null, errlog);
        TimedCollection specp = new TimedCollection(dcm, errlog);
        System.out.printf("spec= %s%n%s%n", spec, specp);
        String err = errlog.toString();
        if (err.length() > 0) {
            System.out.printf("%s%n", err);
        }
        System.out.printf("-----------------------------------%n", new Object[0]);
    }

    public static void main(String[] arg) throws IOException {
        TimedCollection.doit("C:/data/formats/gempak/surface/#yyyyMMdd#_sao.gem", new Formatter());
    }

    public class Dataset {
        String location;
        CalendarDateRange dateRange;
        CalendarDate start;

        Dataset(MFile f) {
            this.location = f.getPath();
            this.start = TimedCollection.this.manager.extractRunDate(f);
        }

        public String getLocation() {
            return this.location;
        }

        public CalendarDateRange getDateRange() {
            return this.dateRange;
        }

        public void setDateRange(CalendarDateRange dateRange) {
            this.dateRange = dateRange;
        }

        public String toString() {
            return "Dataset{location='" + this.location + '\'' + ", dateRange=" + this.dateRange + '}';
        }
    }
}

