/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.out;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.gui.GUITools;
import loci.formats.gui.Index16ColorModel;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import loci.plugins.BF;
import loci.plugins.LociExporter;
import loci.plugins.util.ROIHandler;
import loci.plugins.util.RecordedImageProcessor;
import loci.plugins.util.WindowTools;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Image;
import ome.xml.model.ROI;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;

public class Exporter {
    private static final String ORDER = "XYCZT";
    private ImagePlus imp;
    private LociExporter plugin;

    private String removeExtension(String name) {
        int windowsPos;
        int index = name.lastIndexOf(".");
        int unixPos = name.lastIndexOf(47);
        int max = Math.max(unixPos, windowsPos = name.lastIndexOf(92));
        if (max < index) {
            return name.substring(0, index);
        }
        return name;
    }

    public Exporter(LociExporter plugin, ImagePlus imp) {
        this.plugin = plugin;
        this.imp = imp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String save;
        String options;
        String outfile = null;
        Boolean splitZ = null;
        Boolean splitC = null;
        Boolean splitT = null;
        Boolean padded = null;
        Boolean saveRoi = null;
        String compression = null;
        Boolean windowless = Boolean.FALSE;
        if (this.plugin.arg != null) {
            String w;
            outfile = Macro.getValue((String)this.plugin.arg, (String)"outfile", null);
            String z = Macro.getValue((String)this.plugin.arg, (String)"splitZ", null);
            String c = Macro.getValue((String)this.plugin.arg, (String)"splitC", null);
            String t = Macro.getValue((String)this.plugin.arg, (String)"splitT", null);
            String zeroPad = Macro.getValue((String)this.plugin.arg, (String)"padded", null);
            String sr = Macro.getValue((String)this.plugin.arg, (String)"saveRoi", null);
            compression = Macro.getValue((String)this.plugin.arg, (String)"compression", null);
            String id = Macro.getValue((String)this.plugin.arg, (String)"imageid", null);
            splitZ = z == null ? null : Boolean.valueOf(z);
            splitC = c == null ? null : Boolean.valueOf(c);
            splitT = t == null ? null : Boolean.valueOf(t);
            padded = zeroPad == null ? null : Boolean.valueOf(zeroPad);
            Boolean bl = saveRoi = sr == null ? null : Boolean.valueOf(sr);
            if (id != null) {
                try {
                    int imageID = Integer.parseInt(id);
                    ImagePlus plus = WindowManager.getImage((int)imageID);
                    if (plus != null) {
                        this.imp = plus;
                    }
                }
                catch (Exception imageID) {
                    // empty catch block
                }
            }
            if ((w = Macro.getValue((String)this.plugin.arg, (String)"windowless", null)) != null) {
                windowless = Boolean.valueOf(w);
            }
            this.plugin.arg = null;
        }
        if (outfile == null && (options = Macro.getOptions()) != null && (save = Macro.getValue((String)options, (String)"save", null)) != null) {
            outfile = save;
        }
        if (windowless.booleanValue() && (outfile == null || outfile.length() == 0)) {
            File tmp = null;
            try {
                String name = this.removeExtension(this.imp.getTitle());
                String n = name + ".ome.tif";
                tmp = File.createTempFile(name, ".ome.tif");
                File p = tmp.getParentFile();
                File[] list = p.listFiles();
                if (list != null) {
                    File toDelete = null;
                    for (int i = 0; i < list.length; ++i) {
                        if (!list[i].getName().equals(n)) continue;
                        toDelete = list[i];
                        break;
                    }
                    if (toDelete != null) {
                        toDelete.delete();
                    }
                }
                outfile = new File(p, n).getAbsolutePath();
                if (Recorder.record) {
                    Recorder.recordPath((String)"outputfile", (String)outfile);
                }
                IJ.log((String)("exporter outputfile " + outfile));
            }
            catch (Exception name) {
            }
            finally {
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }
        File f = null;
        if (outfile == null || outfile.length() == 0) {
            int returnVal;
            String dir = null;
            String name = null;
            JFileChooser fc = GUITools.buildFileChooser(new ImageWriter(), false);
            fc.setDialogTitle("Bio-Formats Exporter");
            String defaultDir = OpenDialog.getDefaultDirectory();
            if (defaultDir != null) {
                fc.setCurrentDirectory(new File(defaultDir));
            }
            FileFilter[] ff = fc.getChoosableFileFilters();
            ExtensionFileFilter defaultFilter = null;
            for (int i = 0; i < ff.length; ++i) {
                if (!(ff[i] instanceof ExtensionFileFilter)) continue;
                ExtensionFileFilter eff = (ExtensionFileFilter)ff[i];
                if (i != 0 && !eff.getExtension().equals("ome.tif")) continue;
                defaultFilter = eff;
                break;
            }
            if (defaultFilter != null) {
                fc.setFileFilter(defaultFilter);
            }
            if ((returnVal = fc.showSaveDialog((Component)IJ.getInstance())) != 0) {
                Macro.abort();
                return;
            }
            f = fc.getSelectedFile();
            dir = fc.getCurrentDirectory().getPath() + File.separator;
            name = fc.getName(f);
            if (f.exists()) {
                int ret = JOptionPane.showConfirmDialog(fc, "The file " + f.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2);
                if (ret != 0) {
                    f = null;
                }
            } else {
                FileFilter filter = fc.getFileFilter();
                if (filter instanceof ExtensionFileFilter) {
                    int ret1;
                    String filePath;
                    ExtensionFileFilter eff = (ExtensionFileFilter)filter;
                    String[] ext = eff.getExtensions();
                    String lName = name.toLowerCase();
                    boolean hasExtension = false;
                    for (int i = 0; i < ext.length; ++i) {
                        if (!lName.endsWith("." + ext[i])) continue;
                        hasExtension = true;
                        break;
                    }
                    if (!hasExtension && ext.length > 0) {
                        name = name + "." + ext[0];
                    }
                    if (!(filePath = (f = fc.getSelectedFile()).getAbsolutePath()).endsWith("." + ext[0])) {
                        f = new File(filePath + '.' + ext[0]);
                    }
                    if (f.exists() && (ret1 = JOptionPane.showConfirmDialog(fc, "The file " + f.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
                        f = null;
                    }
                }
            }
            if (f == null) {
                Macro.abort();
            } else {
                OpenDialog.setDefaultDirectory((String)dir);
                if (Recorder.record) {
                    Recorder.recordPath((String)"save", (String)(dir + name));
                }
            }
            if (dir == null || name == null) {
                return;
            }
            outfile = new File(dir, name).getAbsolutePath();
            if (outfile == null) {
                return;
            }
        }
        if (windowless.booleanValue()) {
            if (splitZ == null) {
                splitZ = Boolean.FALSE;
            }
            if (splitC == null) {
                splitC = Boolean.FALSE;
            }
            if (splitT == null) {
                splitT = Boolean.FALSE;
            }
            if (padded == null) {
                padded = Boolean.FALSE;
            }
        }
        if (splitZ == null || splitC == null || splitT == null) {
            GenericDialog multiFile = new GenericDialog("Bio-Formats Exporter - Multiple Files");
            multiFile.addCheckbox("Write_each_Z_section to a separate file", false);
            multiFile.addCheckbox("Write_each_timepoint to a separate file", false);
            multiFile.addCheckbox("Write_each_channel to a separate file", false);
            multiFile.addCheckbox("Use zero padding for filename indexes", false);
            multiFile.showDialog();
            splitZ = multiFile.getNextBoolean();
            splitT = multiFile.getNextBoolean();
            splitC = multiFile.getNextBoolean();
            padded = multiFile.getNextBoolean();
            if (multiFile.wasCanceled()) {
                return;
            }
        }
        try {
            boolean notSupportedType;
            int rate;
            String imageInfo;
            Object info;
            OMEXMLMetadataRoot root;
            int ptype = 0;
            int channels = 1;
            switch (this.imp.getType()) {
                case 0: 
                case 3: {
                    ptype = 1;
                    break;
                }
                case 4: {
                    channels = 3;
                    ptype = 1;
                    break;
                }
                case 1: {
                    ptype = 3;
                    break;
                }
                case 2: {
                    ptype = 6;
                }
            }
            String title = this.imp.getTitle();
            IFormatWriter w = new ImageWriter().getWriter(outfile);
            w.setWriteSequentially(true);
            FileInfo fi = this.imp.getOriginalFileInfo();
            String xml = fi == null ? null : (fi.description == null ? null : (fi.description.indexOf("xml") == -1 ? null : fi.description));
            OMEXMLService service = null;
            ome.xml.meta.MetadataStore store = null;
            try {
                ServiceFactory factory = new ServiceFactory();
                service = factory.getInstance(OMEXMLService.class);
                store = service.createOMEXMLMetadata(xml);
            }
            catch (DependencyException factory) {
            }
            catch (ServiceException factory) {
                // empty catch block
            }
            if (store == null) {
                IJ.error((String)"OME-XML Java library not found.");
            }
            if ((root = (OMEXMLMetadataRoot)store.getRoot()).sizeOfROIList() > 0) {
                while (root.sizeOfROIList() > 0) {
                    ROI roi = root.getROI(0);
                    root.removeROI(roi);
                }
                store.setRoot(root);
            }
            if (xml == null) {
                store.createRoot();
            } else if (store.getImageCount() > 1) {
                int series;
                ArrayList<Integer> matchingSeries = new ArrayList<Integer>();
                for (series = 0; series < store.getImageCount(); ++series) {
                    String imageName;
                    String type = store.getPixelsType(series).toString();
                    int pixelType = FormatTools.pixelTypeFromString(type);
                    if (pixelType != ptype || title.indexOf(imageName = store.getImageName(series)) < 0) continue;
                    matchingSeries.add(series);
                }
                series = 0;
                if (matchingSeries.size() > 1) {
                    for (int i = 0; i < matchingSeries.size(); ++i) {
                        int index = (Integer)matchingSeries.get(i);
                        String name = store.getImageName(index);
                        boolean valid = true;
                        for (int j = 0; j < matchingSeries.size(); ++j) {
                            String compName;
                            if (i == j || (compName = store.getImageName((Integer)matchingSeries.get(j))).indexOf(name) < 0) continue;
                            valid = false;
                            break;
                        }
                        if (!valid) continue;
                        series = index;
                        break;
                    }
                } else if (matchingSeries.size() == 1) {
                    series = (Integer)matchingSeries.get(0);
                }
                Image exportImage = root.getImage(series);
                List<Image> allImages = root.copyImageList();
                for (Image img : allImages) {
                    if (img.equals(exportImage)) continue;
                    root.removeImage(img);
                }
                store.setRoot(root);
            }
            store.setPixelsSizeX(new PositiveInteger(this.imp.getWidth()), 0);
            store.setPixelsSizeY(new PositiveInteger(this.imp.getHeight()), 0);
            store.setPixelsSizeZ(new PositiveInteger(this.imp.getNSlices()), 0);
            store.setPixelsSizeC(new PositiveInteger(channels * this.imp.getNChannels()), 0);
            store.setPixelsSizeT(new PositiveInteger(this.imp.getNFrames()), 0);
            if (store.getImageID(0) == null) {
                store.setImageID(MetadataTools.createLSID("Image", 0), 0);
            }
            if (store.getPixelsID(0) == null) {
                store.setPixelsID(MetadataTools.createLSID("Pixels", 0), 0);
            }
            boolean applyCalibrationFunction = false;
            try {
                int originalType = -1;
                if (store.getPixelsType(0) != null) {
                    originalType = FormatTools.pixelTypeFromString(store.getPixelsType(0).toString());
                }
                if (!(ptype == originalType || store.getPixelsType(0) != null && FormatTools.isSigned(originalType) && FormatTools.getBytesPerPixel(originalType) == FormatTools.getBytesPerPixel(ptype))) {
                    store.setPixelsType(PixelType.fromString(FormatTools.getPixelTypeString(ptype)), 0);
                } else if (FormatTools.isSigned(originalType)) {
                    applyCalibrationFunction = true;
                }
            }
            catch (EnumerationException originalType) {
                // empty catch block
            }
            if (store.getPixelsBinDataCount(0) == 0 || store.getPixelsBinDataBigEndian(0, 0) == null) {
                store.setPixelsBinDataBigEndian(Boolean.FALSE, 0, 0);
            }
            if (store.getPixelsDimensionOrder(0) == null) {
                try {
                    store.setPixelsDimensionOrder(DimensionOrder.fromString(ORDER), 0);
                }
                catch (EnumerationException originalType) {
                    // empty catch block
                }
            }
            LUT[] luts = new LUT[this.imp.getNChannels()];
            for (int c = 0; c < this.imp.getNChannels(); ++c) {
                if (c >= store.getChannelCount(0) || store.getChannelID(0, c) == null) {
                    String lsid = MetadataTools.createLSID("Channel", 0, c);
                    store.setChannelID(lsid, 0, c);
                }
                store.setChannelSamplesPerPixel(new PositiveInteger(channels), 0, 0);
                if (!(this.imp instanceof CompositeImage)) continue;
                luts[c] = ((CompositeImage)this.imp).getChannelLut(c + 1);
            }
            Calibration cal = this.imp.getCalibration();
            store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(cal.pixelWidth), 0);
            store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(cal.pixelHeight), 0);
            store.setPixelsPhysicalSizeZ(FormatTools.getPhysicalSizeZ(cal.pixelDepth), 0);
            store.setPixelsTimeIncrement(new Time(new Double(cal.frameInterval), UNITS.SECOND), 0);
            if (this.imp.getImageStackSize() != this.imp.getNChannels() * this.imp.getNSlices() * this.imp.getNFrames()) {
                if (!windowless.booleanValue()) {
                    IJ.showMessageWithCancel((String)"Bio-Formats Exporter Warning", (String)("The number of planes in the stack (" + this.imp.getImageStackSize() + ") does not match the number of expected planes (" + this.imp.getNChannels() * this.imp.getNSlices() * this.imp.getNFrames() + ").\nIf you select 'OK', only " + this.imp.getImageStackSize() + " planes will be exported. If you wish to export all of the planes,\nselect 'Cancel' and convert the Image5D window to a stack."));
                }
                store.setPixelsSizeZ(new PositiveInteger(this.imp.getImageStackSize()), 0);
                store.setPixelsSizeC(new PositiveInteger(1), 0);
                store.setPixelsSizeT(new PositiveInteger(1), 0);
            }
            if ((info = this.imp.getProperty("Info")) != null && (imageInfo = info.toString()) != null) {
                String[] lines;
                for (String line : lines = imageInfo.split("\n")) {
                    int eq = line.lastIndexOf("=");
                    if (eq <= 0) continue;
                    String key = line.substring(0, eq).trim();
                    String value = line.substring(eq + 1).trim();
                    if (!key.endsWith("BitsPerPixel")) continue;
                    w.setValidBitsPerPixel(Integer.parseInt(value));
                    break;
                }
            }
            if ((rate = cal.fps != 0.0 ? (int)cal.fps : (cal.frameInterval != 0.0 && cal.getTimeUnit().equals("sec") ? (int)(1.0 / cal.frameInterval) : (int)Prefs.getDouble((String)"fps", (double)7.0))) > 0) {
                w.setFramesPerSecond(rate);
            }
            String[] outputFiles = new String[]{outfile};
            int sizeZ = (Integer)store.getPixelsSizeZ(0).getValue();
            int sizeC = (Integer)store.getPixelsSizeC(0).getValue();
            int sizeT = (Integer)store.getPixelsSizeT(0).getValue();
            if (splitZ.booleanValue() || splitC.booleanValue() || splitT.booleanValue()) {
                int nFiles = 1;
                if (splitZ.booleanValue()) {
                    nFiles *= sizeZ;
                }
                if (splitC.booleanValue()) {
                    nFiles *= sizeC;
                }
                if (splitT.booleanValue()) {
                    nFiles *= sizeT;
                }
                outputFiles = new String[nFiles];
                int dot = outfile.indexOf(".", outfile.lastIndexOf(File.separator));
                String base = outfile.substring(0, dot);
                String ext = outfile.substring(dot);
                int nextFile = 0;
                for (int z = 0; z < (splitZ != false ? sizeZ : 1); ++z) {
                    for (int c = 0; c < (splitC != false ? sizeC : 1); ++c) {
                        for (int t = 0; t < (splitT != false ? sizeT : 1); ++t) {
                            int index = FormatTools.getIndex(ORDER, sizeZ, sizeC, sizeT, sizeZ * sizeC * sizeT, z, c, t);
                            String pattern = base + (splitZ != false ? "_Z%z" : "") + (splitC != false ? "_C%c" : "") + (splitT != false ? "_T%t" : "") + ext;
                            outputFiles[nextFile++] = FormatTools.getFilename(0, index, (MetadataRetrieve)((Object)store), pattern, (boolean)padded);
                        }
                    }
                }
            }
            if (!w.getFormat().startsWith("OME")) {
                if (splitZ.booleanValue()) {
                    store.setPixelsSizeZ(new PositiveInteger(1), 0);
                }
                if (splitC.booleanValue()) {
                    store.setPixelsSizeC(new PositiveInteger(1), 0);
                }
                if (splitT.booleanValue()) {
                    store.setPixelsSizeT(new PositiveInteger(1), 0);
                }
            }
            String[] codecs = w.getCompressionTypes();
            ImageProcessor proc = this.imp.getImageStack().getProcessor(1);
            java.awt.Image firstImage = proc.createImage();
            firstImage = AWTImageTools.makeBuffered(firstImage, proc.getColorModel());
            int thisType = AWTImageTools.getPixelType((BufferedImage)firstImage);
            if (proc instanceof ColorProcessor) {
                thisType = 1;
            } else if (proc instanceof ShortProcessor) {
                thisType = 3;
            }
            boolean bl = notSupportedType = !w.isSupportedType(thisType);
            if (notSupportedType) {
                IJ.error((String)("Pixel type (" + FormatTools.getPixelTypeString(thisType) + ") not supported by this format."));
            }
            if (codecs != null && codecs.length > 1) {
                boolean selected = false;
                if (compression != null) {
                    for (int i = 0; i < codecs.length; ++i) {
                        if (!codecs[i].equals(compression)) continue;
                        selected = true;
                        break;
                    }
                }
                if (!selected && !windowless.booleanValue()) {
                    GenericDialog gd = new GenericDialog("Bio-Formats Exporter Options");
                    gd.addChoice("Compression type: ", codecs, codecs[0]);
                    if (saveRoi != null) {
                        gd.addCheckbox("Export ROIs", saveRoi.booleanValue());
                    } else {
                        gd.addCheckbox("Export ROIs", true);
                    }
                    gd.showDialog();
                    saveRoi = gd.getNextBoolean();
                    if (gd.wasCanceled()) {
                        return;
                    }
                    compression = gd.getNextChoice();
                }
            }
            boolean in = false;
            if (outputFiles.length > 1) {
                for (int i = 0; i < outputFiles.length; ++i) {
                    if (!new File(outputFiles[i]).exists()) continue;
                    in = true;
                    break;
                }
            }
            if (in && !windowless.booleanValue()) {
                int ret1 = JOptionPane.showConfirmDialog(null, "Some files already exist. \nWould you like to replace them?", "Replace?", 0, 2);
                if (ret1 != 0) {
                    return;
                }
                for (int i = 0; i < outputFiles.length; ++i) {
                    new File(outputFiles[i]).delete();
                }
            }
            if (f != null) {
                f.delete();
            }
            if (compression != null) {
                w.setCompression(compression);
            }
            if (saveRoi != null && saveRoi.booleanValue()) {
                ROIHandler.saveROIs((MetadataStore)store);
            }
            w.setMetadataRetrieve((MetadataRetrieve)((Object)store));
            int size = this.imp.getImageStackSize();
            ImageStack is = this.imp.getImageStack();
            boolean doStack = w.canDoStacks() && size > 1;
            int start = doStack ? 0 : this.imp.getCurrentSlice() - 1;
            int end = doStack ? size : start + 1;
            boolean littleEndian = false;
            if (w.getMetadataRetrieve().getPixelsBigEndian(0) != null) {
                littleEndian = w.getMetadataRetrieve().getPixelsBigEndian(0) == false;
            } else if (w.getMetadataRetrieve().getPixelsBinDataCount(0) == 0) {
                littleEndian = w.getMetadataRetrieve().getPixelsBinDataBigEndian(0, 0) == false;
            }
            byte[] plane = null;
            w.setInterleaved(false);
            int[] no = new int[outputFiles.length];
            for (int i = start; i < end; ++i) {
                int pixel;
                if (doStack) {
                    BF.status(false, "Saving plane " + (i + 1) + "/" + size);
                    BF.progress(false, i, size);
                } else {
                    BF.status(false, "Saving image");
                }
                proc = is.getProcessor(i + 1);
                if (proc instanceof RecordedImageProcessor) {
                    proc = ((RecordedImageProcessor)proc).getChild();
                }
                int x = proc.getWidth();
                int y = proc.getHeight();
                if (proc instanceof ByteProcessor) {
                    if (applyCalibrationFunction) {
                        byte[] pixels = (byte[])proc.getPixels();
                        plane = new byte[pixels.length];
                        float[] calibration = proc.getCalibrationTable();
                        for (pixel = 0; pixel < pixels.length; ++pixel) {
                            plane[pixel] = (byte)calibration[pixels[pixel] & 0xFF];
                        }
                    } else {
                        plane = (byte[])proc.getPixels();
                    }
                } else if (proc instanceof ShortProcessor) {
                    short[] pixels = (short[])proc.getPixels();
                    if (applyCalibrationFunction) {
                        plane = new byte[pixels.length * 2];
                        float[] calibration = proc.getCalibrationTable();
                        for (pixel = 0; pixel < pixels.length; ++pixel) {
                            short v = (short)calibration[pixels[pixel] & 0xFFFF];
                            DataTools.unpackBytes(v, plane, pixel * 2, 2, littleEndian);
                        }
                    } else {
                        plane = DataTools.shortsToBytes(pixels, littleEndian);
                    }
                } else if (proc instanceof FloatProcessor) {
                    plane = DataTools.floatsToBytes((float[])proc.getPixels(), littleEndian);
                } else if (proc instanceof ColorProcessor) {
                    byte[][] pix = new byte[3][x * y];
                    ((ColorProcessor)proc).getRGB(pix[0], pix[1], pix[2]);
                    plane = new byte[3 * x * y];
                    System.arraycopy(pix[0], 0, plane, 0, x * y);
                    System.arraycopy(pix[1], 0, plane, x * y, x * y);
                    System.arraycopy(pix[2], 0, plane, 2 * x * y, x * y);
                    if (i == start) {
                        sizeC /= 3;
                    }
                }
                int fileIndex = 0;
                if (doStack) {
                    int[] coords = FormatTools.getZCTCoords(ORDER, sizeZ, sizeC, sizeT, size, i);
                    int realZ = sizeZ;
                    int realC = sizeC;
                    int realT = sizeT;
                    if (!splitZ.booleanValue()) {
                        coords[0] = 0;
                        realZ = 1;
                    }
                    if (!splitC.booleanValue()) {
                        coords[1] = 0;
                        realC = 1;
                    }
                    if (!splitT.booleanValue()) {
                        coords[2] = 0;
                        realT = 1;
                    }
                    fileIndex = FormatTools.getIndex(ORDER, realZ, realC, realT, realZ * realC * realT, coords[0], coords[1], coords[2]);
                }
                if (notSupportedType) {
                    IJ.error((String)"Pixel type not supported by this format.");
                    continue;
                }
                w.changeOutputFile(outputFiles[fileIndex]);
                int currentChannel = FormatTools.getZCTCoords(ORDER, sizeZ, sizeC, sizeT, this.imp.getStackSize(), i)[1];
                if (luts[currentChannel] != null) {
                    int bpp = FormatTools.getBytesPerPixel(thisType);
                    if (bpp == 1) {
                        w.setColorModel((ColorModel)luts[currentChannel]);
                    } else if (bpp == 2) {
                        int lutSize = luts[currentChannel].getMapSize();
                        byte[][] lut = new byte[3][lutSize];
                        luts[currentChannel].getReds(lut[0]);
                        luts[currentChannel].getGreens(lut[1]);
                        luts[currentChannel].getBlues(lut[2]);
                        short[][] newLut = new short[3][65536];
                        int bins = newLut[0].length / lut[0].length;
                        for (int c = 0; c < newLut.length; ++c) {
                            for (int q = 0; q < newLut[c].length; ++q) {
                                int index = q / bins;
                                newLut[c][q] = (short)(lut[c][index] * lut[0].length + q % bins);
                            }
                        }
                        w.setColorModel(new Index16ColorModel(16, newLut[0].length, newLut, littleEndian));
                    }
                } else if (!proc.isDefaultLut()) {
                    w.setColorModel(proc.getColorModel());
                }
                int n = fileIndex;
                int n2 = no[n];
                no[n] = n2 + 1;
                w.saveBytes(n2, plane);
            }
            w.close();
        }
        catch (FormatException e) {
            WindowTools.reportException(e);
        }
        catch (IOException e) {
            WindowTools.reportException(e);
        }
    }
}

