/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LIFReader
extends FormatReader {
    public static final String OLD_PHYSICAL_SIZE_KEY = "leicalif.old_physical_size";
    public static final boolean OLD_PHYSICAL_SIZE_DEFAULT = false;
    public static final byte LIF_MAGIC_BYTE = 112;
    public static final byte LIF_MEMORY_BYTE = 42;
    private static final String ENCODING = "ISO-8859-1";
    private static final ImmutableMap<String, Integer> CHANNEL_PRIORITIES = LIFReader.createChannelPriorities();
    private List<Long> offsets;
    private int[][] realChannel;
    private int lastChannel = 0;
    private List<String> lutNames = new ArrayList<String>();
    private List<Double> physicalSizeXs = new ArrayList<Double>();
    private List<Double> physicalSizeYs = new ArrayList<Double>();
    private List<Length> fieldPosX = new ArrayList<Length>();
    private List<Length> fieldPosY = new ArrayList<Length>();
    private String[] descriptions;
    private String[] microscopeModels;
    private String[] serialNumber;
    private Double[] pinholes;
    private Double[] zooms;
    private Double[] zSteps;
    private Double[] tSteps;
    private Double[] lensNA;
    private Double[][] expTimes;
    private Double[][] gains;
    private Double[][] detectorOffsets;
    private String[][] channelNames;
    private List[] detectorModels;
    private Double[][] exWaves;
    private List[] activeDetector;
    private HashMap[] detectorIndexes;
    private String[] immersions;
    private String[] corrections;
    private String[] objectiveModels;
    private Double[] magnification;
    private Length[] posX;
    private Length[] posY;
    private Length[] posZ;
    private Double[] refractiveIndex;
    private List[] cutIns;
    private List[] cutOuts;
    private List[] filterModels;
    private Double[][] timestamps;
    private List[] laserWavelength;
    private List[] laserIntensity;
    private List[] laserActive;
    private List[] laserFrap;
    private ROI[][] imageROIs;
    private boolean alternateCenter = false;
    private String[] imageNames;
    private double[] acquiredDate;
    private int[] tileCount;
    private long[] tileBytesInc;
    private long endPointer;

    private static ImmutableMap<String, Integer> createChannelPriorities() {
        ImmutableMap.Builder<String, Integer> h = ImmutableMap.builder();
        h.put("red", 0);
        h.put("green", 1);
        h.put("blue", 2);
        h.put("cyan", 3);
        h.put("magenta", 4);
        h.put("yellow", 5);
        h.put("black", 6);
        h.put("gray", 7);
        h.put("", 8);
        return h.build();
    }

    public LIFReader() {
        super("Leica Image File Format", "lif");
        this.suffixNecessary = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean useOldPhysicalSizeCalculation() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(OLD_PHYSICAL_SIZE_KEY, false);
        }
        return false;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean blockLen = true;
        if (!FormatTools.validStream(stream, 1, true)) {
            return false;
        }
        return stream.read() == 112;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= 9) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        block8: for (int i = 0; i < 256; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                }
            }
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 3 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= 9) {
            return null;
        }
        short[][] lut = new short[3][65536];
        block8: for (int i = 0; i < 65536; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[1][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[1][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                }
            }
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int index;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (!this.isRGB()) {
            int[] pos = this.getZCTCoords(no);
            this.lastChannel = this.realChannel[this.getTileIndex(this.series)][pos[1]];
        }
        if ((index = this.getTileIndex(this.series)) >= this.offsets.size()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        long offset = this.offsets.get(index);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int bpp = bytes * this.getRGBChannelCount();
        long planeSize = (long)this.getSizeX() * (long)this.getSizeY() * (long)bpp;
        long nextOffset = index + 1 < this.offsets.size() ? this.offsets.get(index + 1) : this.endPointer;
        int bytesToSkip = (int)(nextOffset - offset - planeSize * (long)this.getImageCount());
        bytesToSkip /= this.getSizeY();
        if (this.getSizeX() % 4 == 0) {
            bytesToSkip = 0;
        }
        if (offset + (planeSize + (long)(bytesToSkip * this.getSizeY())) * (long)no >= this.in.length()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        this.seekStartOfPlane(no, offset, planeSize);
        if (bytesToSkip == 0) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            this.in.skipBytes(bytesToSkip * this.getSizeY() * no);
            this.in.skipBytes(y * (this.getSizeX() * bpp + bytesToSkip));
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * bpp);
                this.in.read(buf, row * w * bpp, w * bpp);
                this.in.skipBytes(bpp * (this.getSizeX() - w - x) + bytesToSkip);
            }
        }
        if (this.getRGBChannelCount() == 3) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), bytes, this.getRGBChannelCount());
        }
        return buf;
    }

    private void seekStartOfPlane(int no, long dataOffset, long planeSize) throws IOException {
        long posInFile;
        int index = this.getTileIndex(this.series);
        int numberOfTiles = this.tileCount[index];
        if (numberOfTiles > 1) {
            long bytesIncPerTile = this.tileBytesInc[index];
            long framesPerTile = bytesIncPerTile / planeSize;
            if (framesPerTile > Integer.MAX_VALUE) {
                throw new IOException("Could not read frame due to int overflow");
            }
            int noOutsideTiles = no / (int)framesPerTile;
            int noInsideTiles = no % (int)framesPerTile;
            int tile = this.series;
            for (int i = 0; i < index; ++i) {
                tile -= this.tileCount[i];
            }
            posInFile = dataOffset;
            posInFile += (long)noOutsideTiles * bytesIncPerTile * (long)numberOfTiles;
            posInFile += (long)tile * bytesIncPerTile;
            posInFile += (long)noInsideTiles * planeSize;
        } else {
            posInFile = dataOffset + (long)no * planeSize;
        }
        this.in.seek(posInFile);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.realChannel = null;
            this.lastChannel = 0;
            this.lutNames.clear();
            this.physicalSizeXs.clear();
            this.physicalSizeYs.clear();
            this.serialNumber = null;
            this.microscopeModels = null;
            this.descriptions = null;
            this.lensNA = null;
            this.zooms = null;
            this.pinholes = null;
            this.tSteps = null;
            this.zSteps = null;
            this.gains = null;
            this.expTimes = this.gains;
            this.detectorOffsets = null;
            this.channelNames = null;
            this.detectorModels = null;
            this.exWaves = null;
            this.activeDetector = null;
            this.corrections = null;
            this.immersions = null;
            this.magnification = null;
            this.objectiveModels = null;
            this.posZ = null;
            this.posY = null;
            this.posX = null;
            this.refractiveIndex = null;
            this.filterModels = null;
            this.cutOuts = null;
            this.cutIns = null;
            this.timestamps = null;
            this.laserFrap = null;
            this.laserActive = null;
            this.laserIntensity = null;
            this.laserWavelength = null;
            this.imageROIs = null;
            this.alternateCenter = false;
            this.imageNames = null;
            this.acquiredDate = null;
            this.detectorIndexes = null;
            this.tileCount = null;
            this.tileBytesInc = null;
            this.fieldPosX.clear();
            this.fieldPosY.clear();
            this.endPointer = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.setEncoding(ENCODING);
        this.offsets = new ArrayList<Long>();
        this.in.order(true);
        LOGGER.info("Reading header");
        byte checkOne = this.in.readByte();
        this.in.skipBytes(2);
        byte checkTwo = this.in.readByte();
        if (checkOne != 112 && checkTwo != 112) {
            throw new FormatException(id + " is not a valid Leica LIF file");
        }
        this.in.skipBytes(4);
        if (this.in.read() != 42) {
            throw new FormatException("Invalid XML description");
        }
        int nc = this.in.readInt();
        String xml = DataTools.stripString(this.in.readString(nc * 2));
        LOGGER.info("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            LOGGER.debug("Looking for a block at {}; {} blocks read", (Object)this.in.getFilePointer(), (Object)this.offsets.size());
            int check = this.in.readInt();
            if (check != 112) {
                if (check == 0 && this.offsets.size() > 0) {
                    this.endPointer = this.in.getFilePointer();
                    break;
                }
                throw new FormatException("Invalid Memory Block: found magic bytes " + check + ", expected " + 112);
            }
            this.in.skipBytes(4);
            check = this.in.read();
            if (check != 42) {
                throw new FormatException("Invalid Memory Description: found magic byte " + check + ", expected " + 42);
            }
            long blockLength = this.in.readInt();
            if (this.in.read() != 42) {
                this.in.seek(this.in.getFilePointer() - 5L);
                blockLength = this.in.readLong();
                check = this.in.read();
                if (check != 42) {
                    throw new FormatException("Invalid Memory Description: found magic byte " + check + ", expected " + 42);
                }
            }
            int descrLength = this.in.readInt() * 2;
            if (blockLength > 0L) {
                this.offsets.add(this.in.getFilePointer() + (long)descrLength);
            }
            this.in.seek(this.in.getFilePointer() + (long)descrLength + blockLength);
        }
        this.initMetadata(xml);
        xml = null;
        if (this.endPointer == 0L) {
            this.endPointer = this.in.length();
        }
        if (this.offsets.size() > this.getSeriesCount()) {
            Long[] storedOffsets = this.offsets.toArray(new Long[this.offsets.size()]);
            this.offsets.clear();
            int index = 0;
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                long end;
                this.setSeries(i);
                long nBytes = (long)FormatTools.getPlaneSize(this) * (long)this.getImageCount();
                long start = storedOffsets[index];
                long l = end = index == storedOffsets.length - 1 ? this.in.length() : storedOffsets[index + 1].longValue();
                while (end - start < nBytes && (end - start) / nBytes != 1L) {
                    start = storedOffsets[++index];
                    end = index == storedOffsets.length - 1 ? this.in.length() : storedOffsets[index + 1].longValue();
                }
                this.offsets.add(storedOffsets[index]);
                ++index;
            }
            this.setSeries(0);
        }
    }

    private void initMetadata(String xml) throws FormatException, IOException {
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", exc);
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", exc);
        }
        MetadataStore store = this.makeFilterMetadata();
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>" + xml + "</LEICA>";
        xml = XMLTools.sanitizeXML(xml);
        this.translateMetadata(this.getMetadataRoot(xml));
        for (int i = 0; i < this.imageNames.length; ++i) {
            this.setSeries(i);
            this.addSeriesMeta("Image name", this.imageNames[i]);
        }
        this.setSeries(0);
        this.realChannel = new int[this.tileCount.length][];
        int nextLut = 0;
        for (int i = 0; i < this.core.size(); ++i) {
            int index = this.getTileIndex(i);
            if (this.realChannel[index] != null) continue;
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            this.realChannel[index] = new int[ms.sizeC];
            for (int q = 0; q < ms.sizeC; ++q) {
                String lut = "";
                if (nextLut < this.lutNames.size()) {
                    lut = this.lutNames.get(nextLut++).toLowerCase();
                }
                if (!CHANNEL_PRIORITIES.containsKey(lut)) {
                    lut = "";
                }
                this.realChannel[index][q] = CHANNEL_PRIORITIES.get(lut);
            }
            int[] sorted = new int[ms.sizeC];
            Arrays.fill(sorted, -1);
            for (int q = 0; q < sorted.length; ++q) {
                int min = Integer.MAX_VALUE;
                int minIndex = -1;
                for (int n = 0; n < ms.sizeC; ++n) {
                    if (this.realChannel[index][n] >= min || DataTools.containsValue(sorted, n)) continue;
                    min = this.realChannel[index][n];
                    minIndex = n;
                }
                sorted[q] = minIndex;
            }
        }
        MetadataTools.populatePixels(store, this, true, false);
        int roiCount = 0;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            List activeDetectors;
            int firstDetector;
            List detectors;
            this.setSeries(i);
            String instrumentID = MetadataTools.createLSID("Instrument", i);
            store.setInstrumentID(instrumentID, i);
            int index = this.getTileIndex(i);
            store.setMicroscopeModel(this.microscopeModels[index], i);
            store.setMicroscopeType(this.getMicroscopeType("Other"), i);
            String objectiveID = MetadataTools.createLSID("Objective", i, 0);
            store.setObjectiveID(objectiveID, i, 0);
            store.setObjectiveLensNA(this.lensNA[index], i, 0);
            store.setObjectiveSerialNumber(this.serialNumber[index], i, 0);
            if (this.magnification[index] != null) {
                store.setObjectiveNominalMagnification(this.magnification[index], i, 0);
            }
            store.setObjectiveImmersion(this.getImmersion(this.immersions[index]), i, 0);
            store.setObjectiveCorrection(this.getCorrection(this.corrections[index]), i, 0);
            store.setObjectiveModel(this.objectiveModels[index], i, 0);
            if (this.cutIns[index] != null && this.filterModels[index] != null) {
                boolean channel = false;
                if (this.cutIns[index].size() >= this.filterModels[index].size() * 2) {
                    int diff = this.cutIns[index].size() - this.filterModels[index].size();
                    for (int q = 0; q < diff; ++q) {
                        this.cutIns[index].remove(this.filterModels[index].size());
                    }
                }
                for (int filter = 0; filter < this.cutIns[index].size(); ++filter) {
                    String filterID = MetadataTools.createLSID("Filter", i, filter);
                    store.setFilterID(filterID, i, filter);
                    if (this.filterModels[index] != null && filter < this.filterModels[index].size()) {
                        store.setFilterModel((String)this.filterModels[index].get(filter), i, filter);
                    }
                    store.setTransmittanceRangeCutIn((Length)this.cutIns[index].get(filter), i, filter);
                    store.setTransmittanceRangeCutOut((Length)this.cutOuts[index].get(filter), i, filter);
                }
            }
            List lasers = this.laserWavelength[index];
            List laserIntensities = this.laserIntensity[index];
            List active = this.laserActive[index];
            List frap = this.laserFrap[index];
            int nextChannel = 0;
            if (lasers != null) {
                int laserIndex = 0;
                while (laserIndex < lasers.size()) {
                    if ((Double)lasers.get(laserIndex) == 0.0) {
                        lasers.remove(laserIndex);
                        continue;
                    }
                    ++laserIndex;
                }
                for (int laser = 0; laser < lasers.size(); ++laser) {
                    String id = MetadataTools.createLSID("LightSource", i, laser);
                    store.setLaserID(id, i, laser);
                    store.setLaserType(LaserType.OTHER, i, laser);
                    store.setLaserLaserMedium(LaserMedium.OTHER, i, laser);
                    Double wavelength = (Double)lasers.get(laser);
                    Length wave = FormatTools.getWavelength(wavelength);
                    if (wave == null) continue;
                    store.setLaserWavelength(wave, i, laser);
                }
                HashSet<Integer> ignoredChannels = new HashSet<Integer>();
                ArrayList<Integer> validIntensities = new ArrayList<Integer>();
                int size = lasers.size();
                int channel = 0;
                HashSet<Integer> channels = new HashSet<Integer>();
                for (int laser = 0; laser < laserIntensities.size(); ++laser) {
                    double intensity = (Double)laserIntensities.get(laser);
                    channel = laser / size;
                    if (intensity < 100.0) {
                        validIntensities.add(laser);
                        channels.add(channel);
                    }
                    ignoredChannels.add(channel);
                }
                ignoredChannels.removeAll(channels);
                int s = validIntensities.size();
                HashSet toRemove = new HashSet();
                int as = active.size();
                for (int j = 0; j < s; ++j) {
                    int jj;
                    if (j < as && !((Boolean)active.get(j)).booleanValue()) {
                        toRemove.add(validIntensities.get(j));
                    }
                    if ((jj = j + 1) >= s) continue;
                    int v = (Integer)validIntensities.get(j) / size;
                    int vv = (Integer)validIntensities.get(jj) / size;
                    if (vv != v) continue;
                    toRemove.add(validIntensities.get(j));
                    toRemove.add(validIntensities.get(jj));
                    ignoredChannels.add(j);
                }
                if (toRemove.size() > 0) {
                    validIntensities.removeAll(toRemove);
                }
                boolean noNames = true;
                if (this.channelNames[index] != null) {
                    for (String name : this.channelNames[index]) {
                        if (name == null || name.equals("")) continue;
                        noNames = false;
                        break;
                    }
                }
                if (!noNames && frap != null) {
                    for (int k = 0; k < frap.size(); ++k) {
                        if (((Boolean)frap.get(k)).booleanValue()) continue;
                        noNames = true;
                        break;
                    }
                }
                int nextFilter = 0;
                int k = 0;
                while (k < validIntensities.size()) {
                    int laserArrayIndex = (Integer)validIntensities.get(k);
                    double intensity = (Double)laserIntensities.get(laserArrayIndex);
                    int laser = laserArrayIndex % lasers.size();
                    Double wavelength = (Double)lasers.get(laser);
                    if (wavelength != 0.0) {
                        while (ignoredChannels.contains(nextChannel)) {
                            ++nextChannel;
                        }
                        while (this.channelNames != null && nextChannel < this.getEffectiveSizeC() && this.channelNames[index] != null && (this.channelNames[index][nextChannel] == null || this.channelNames[index][nextChannel].equals("")) && !noNames) {
                            ++nextChannel;
                        }
                        if (nextChannel < this.getEffectiveSizeC()) {
                            String id = MetadataTools.createLSID("LightSource", i, laser);
                            store.setChannelLightSourceSettingsID(id, i, nextChannel);
                            store.setChannelLightSourceSettingsAttenuation(new PercentFraction(Float.valueOf((float)intensity / 100.0f)), i, nextChannel);
                            Length ex = FormatTools.getExcitationWavelength(wavelength);
                            if (ex != null) {
                                store.setChannelExcitationWavelength(ex, i, nextChannel);
                            }
                            if (wavelength > 0.0 && this.cutIns[index] != null && nextFilter < this.cutIns[index].size()) {
                                Double cutIn = ((Length)this.cutIns[index].get(nextFilter)).value(UNITS.NANOMETER).doubleValue();
                                while (cutIn - wavelength > 20.0 && ++nextFilter < this.cutIns[index].size()) {
                                    cutIn = ((Length)this.cutIns[index].get(nextFilter)).value(UNITS.NANOMETER).doubleValue();
                                }
                                if (nextFilter < this.cutIns[index].size()) {
                                    String fid = MetadataTools.createLSID("Filter", i, nextFilter++);
                                }
                            }
                        }
                    }
                    ++k;
                    ++nextChannel;
                }
            }
            store.setImageInstrumentRef(instrumentID, i);
            store.setObjectiveSettingsID(objectiveID, i);
            store.setObjectiveSettingsRefractiveIndex(this.refractiveIndex[index], i);
            store.setImageDescription(this.descriptions[index], i);
            if (this.acquiredDate[index] > 0.0) {
                store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate((long)(this.acquiredDate[index] * 1000.0), 1, "yyyy-MM-dd'T'HH:mm:ss", false)), i);
            }
            store.setImageName(this.imageNames[index].trim(), i);
            Length sizeX = FormatTools.getPhysicalSizeX(this.physicalSizeXs.get(index));
            Length sizeY = FormatTools.getPhysicalSizeY(this.physicalSizeYs.get(index));
            Length sizeZ = FormatTools.getPhysicalSizeZ(this.zSteps[index]);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, i);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, i);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, i);
            }
            if (this.tSteps[index] != null) {
                store.setPixelsTimeIncrement(new Time(this.tSteps[index], UNITS.SECOND), i);
            }
            if ((detectors = this.detectorModels[index]) != null) {
                nextChannel = 0;
                int start = detectors.size() - this.getEffectiveSizeC();
                if (start < 0) {
                    start = 0;
                }
                for (int detector = start; detector < detectors.size(); ++detector) {
                    int detectorIndex;
                    int dIndex = detector - start;
                    String detectorID = MetadataTools.createLSID("Detector", i, dIndex);
                    store.setDetectorID(detectorID, i, dIndex);
                    store.setDetectorModel((String)detectors.get(detector), i, dIndex);
                    store.setDetectorZoom(this.zooms[index], i, dIndex);
                    store.setDetectorType(DetectorType.PMT, i, dIndex);
                    if (this.activeDetector[index] == null || (detectorIndex = this.activeDetector[index].size() - this.getEffectiveSizeC() + dIndex) < 0 || detectorIndex >= this.activeDetector[index].size() || !((Boolean)this.activeDetector[index].get(detectorIndex)).booleanValue() || this.detectorOffsets[index] == null || nextChannel >= this.detectorOffsets[index].length) continue;
                    store.setDetectorOffset(this.detectorOffsets[index][nextChannel++], i, dIndex);
                }
            }
            int nextDetector = firstDetector = (activeDetectors = this.activeDetector[index]) == null ? 0 : activeDetectors.size() - this.getEffectiveSizeC();
            int nextFilter = 0;
            int nextFilterDetector = 0;
            if (activeDetectors != null && activeDetectors.size() > this.cutIns[index].size() && ((Boolean)activeDetectors.get(activeDetectors.size() - 1)).booleanValue() && ((Boolean)activeDetectors.get(activeDetectors.size() - 2)).booleanValue()) {
                nextFilterDetector = activeDetectors.size() - this.cutIns[index].size();
                if (this.cutIns[index].size() > this.filterModels[index].size()) {
                    nextFilterDetector += this.filterModels[index].size();
                    nextFilter += this.filterModels[index].size();
                }
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                Length ex;
                if (activeDetectors != null) {
                    while (nextDetector >= 0 && nextDetector < activeDetectors.size() && !((Boolean)activeDetectors.get(nextDetector)).booleanValue()) {
                        ++nextDetector;
                    }
                    if (nextDetector < activeDetectors.size() && detectors != null && nextDetector - firstDetector < detectors.size()) {
                        String detectorID = MetadataTools.createLSID("Detector", i, nextDetector - firstDetector);
                        store.setDetectorSettingsID(detectorID, i, c);
                        ++nextDetector;
                        if (this.detectorOffsets[index] != null && c < this.detectorOffsets[index].length) {
                            store.setDetectorSettingsOffset(this.detectorOffsets[index][c], i, c);
                        }
                        if (this.gains[index] != null) {
                            store.setDetectorSettingsGain(this.gains[index][c], i, c);
                        }
                    }
                }
                if (this.channelNames[index] != null) {
                    store.setChannelName(this.channelNames[index][c], i, c);
                }
                if (this.pinholes[index] != null) {
                    store.setChannelPinholeSize(new Length(this.pinholes[index], UNITS.MICROMETER), i, c);
                }
                if (this.exWaves[index] != null && this.exWaves[index][c] != null && this.exWaves[index][c] > 1.0 && (ex = FormatTools.getExcitationWavelength(this.exWaves[index][c])) != null) {
                    store.setChannelExcitationWavelength(ex, i, c);
                }
                Color channelColor = this.getChannelColor(this.realChannel[index][c]);
                if (!this.isRGB()) {
                    store.setChannelColor(channelColor, i, c);
                }
                if ((Integer)channelColor.getValue() == -1 || nextFilter < 0) continue;
                if (nextDetector - firstDetector != this.getSizeC() && this.cutIns[index] != null && nextDetector >= this.cutIns[index].size()) {
                    while (nextFilterDetector < firstDetector) {
                        String filterID = MetadataTools.createLSID("Filter", i, nextFilter);
                        store.setFilterID(filterID, i, nextFilter);
                        ++nextFilterDetector;
                        ++nextFilter;
                    }
                }
                while (activeDetectors != null && nextFilterDetector < activeDetectors.size() && !((Boolean)activeDetectors.get(nextFilterDetector)).booleanValue()) {
                    String filterID = MetadataTools.createLSID("Filter", i, nextFilter);
                    store.setFilterID(filterID, i, nextFilter);
                    ++nextFilterDetector;
                    ++nextFilter;
                }
                String filterID = MetadataTools.createLSID("Filter", i, nextFilter);
                store.setFilterID(filterID, i, nextFilter);
                store.setLightPathEmissionFilterRef(filterID, i, c, 0);
                ++nextFilterDetector;
                ++nextFilter;
            }
            for (int image = 0; image < this.getImageCount(); ++image) {
                int c;
                Length xPos = this.posX[index];
                Length yPos = this.posY[index];
                if (i < this.fieldPosX.size() && this.fieldPosX.get(i) != null) {
                    xPos = this.fieldPosX.get(i);
                }
                if (i < this.fieldPosY.size() && this.fieldPosY.get(i) != null) {
                    yPos = this.fieldPosY.get(i);
                }
                if (xPos != null) {
                    store.setPlanePositionX(xPos, i, image);
                }
                if (yPos != null) {
                    store.setPlanePositionY(yPos, i, image);
                }
                store.setPlanePositionZ(this.posZ[index], i, image);
                if (this.timestamps[index] != null && this.timestamps[index][image] != null) {
                    double timestamp = this.timestamps[index][image];
                    if (this.timestamps[index][0] == this.acquiredDate[index]) {
                        timestamp -= this.acquiredDate[index];
                    } else if (timestamp == this.acquiredDate[index] && image > 0) {
                        timestamp = this.timestamps[index][0];
                    }
                    store.setPlaneDeltaT(new Time(timestamp, UNITS.SECOND), i, image);
                }
                if (this.expTimes[index] == null || this.expTimes[index][c = this.getZCTCoords(image)[1]] == null) continue;
                store.setPlaneExposureTime(new Time(this.expTimes[index][c], UNITS.SECOND), i, image);
            }
            if (this.imageROIs[index] == null) continue;
            for (int roi = 0; roi < this.imageROIs[index].length; ++roi) {
                if (this.imageROIs[index][roi] == null) continue;
                this.imageROIs[index][roi].storeROI(store, i, roiCount++, roi);
            }
        }
    }

    private Element getMetadataRoot(String xml) throws FormatException, IOException {
        try (ByteArrayInputStream s = null;){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            s = new ByteArrayInputStream(xml.getBytes(ENCODING));
            Element element = parser.parse(s).getDocumentElement();
            return element;
        }
    }

    private void translateMetadata(Element root) throws FormatException {
        Object image;
        int i;
        Element realRoot = (Element)root.getChildNodes().item(0);
        NodeList toPrune = this.getNodes(realRoot, "LDM_Block_Sequential_Master");
        if (toPrune != null) {
            for (int i2 = 0; i2 < toPrune.getLength(); ++i2) {
                Element prune = (Element)toPrune.item(i2);
                Element parent = (Element)prune.getParentNode();
                parent.removeChild(prune);
            }
        }
        NodeList images = this.getNodes(realRoot, "Image");
        ArrayList<Element> imageNodes = new ArrayList<Element>();
        Long[] oldOffsets = null;
        if (images.getLength() > this.offsets.size()) {
            oldOffsets = this.offsets.toArray(new Long[this.offsets.size()]);
            this.offsets.clear();
        }
        int nextOffset = 0;
        for (i = 0; i < images.getLength(); ++i) {
            image = (Element)images.item(i);
            Element grandparent = (Element)image.getParentNode();
            if (grandparent == null || (grandparent = (Element)grandparent.getParentNode()) == null) continue;
            if (!"ProcessingHistory".equals(grandparent.getNodeName())) {
                imageNodes.add((Element)image);
                if (oldOffsets != null && nextOffset < oldOffsets.length) {
                    this.offsets.add(oldOffsets[nextOffset]);
                }
            }
            if ((grandparent = (Element)grandparent.getParentNode()) == null || (grandparent = (Element)grandparent.getParentNode()) == null || "Image".equals(grandparent.getNodeName())) continue;
            ++nextOffset;
        }
        this.tileCount = new int[imageNodes.size()];
        Arrays.fill(this.tileCount, 1);
        this.tileBytesInc = new long[imageNodes.size()];
        this.core = new ArrayList(imageNodes.size());
        this.acquiredDate = new double[imageNodes.size()];
        this.descriptions = new String[imageNodes.size()];
        this.laserWavelength = new List[imageNodes.size()];
        this.laserIntensity = new List[imageNodes.size()];
        this.laserActive = new List[imageNodes.size()];
        this.laserFrap = new List[imageNodes.size()];
        this.timestamps = new Double[imageNodes.size()][];
        this.activeDetector = new List[imageNodes.size()];
        this.serialNumber = new String[imageNodes.size()];
        this.lensNA = new Double[imageNodes.size()];
        this.magnification = new Double[imageNodes.size()];
        this.immersions = new String[imageNodes.size()];
        this.corrections = new String[imageNodes.size()];
        this.objectiveModels = new String[imageNodes.size()];
        this.posX = new Length[imageNodes.size()];
        this.posY = new Length[imageNodes.size()];
        this.posZ = new Length[imageNodes.size()];
        this.refractiveIndex = new Double[imageNodes.size()];
        this.cutIns = new List[imageNodes.size()];
        this.cutOuts = new List[imageNodes.size()];
        this.filterModels = new List[imageNodes.size()];
        this.microscopeModels = new String[imageNodes.size()];
        this.detectorModels = new List[imageNodes.size()];
        this.detectorIndexes = new HashMap[imageNodes.size()];
        this.zSteps = new Double[imageNodes.size()];
        this.tSteps = new Double[imageNodes.size()];
        this.pinholes = new Double[imageNodes.size()];
        this.zooms = new Double[imageNodes.size()];
        this.expTimes = new Double[imageNodes.size()][];
        this.gains = new Double[imageNodes.size()][];
        this.detectorOffsets = new Double[imageNodes.size()][];
        this.channelNames = new String[imageNodes.size()][];
        this.exWaves = new Double[imageNodes.size()][];
        this.imageROIs = new ROI[imageNodes.size()][];
        this.imageNames = new String[imageNodes.size()];
        this.core.clear();
        for (i = 0; i < imageNodes.size(); ++i) {
            image = (Element)imageNodes.get(i);
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            int index = this.core.size() - 1;
            this.setSeries(index);
            this.translateImageNames((Element)image, index);
            this.translateImageNodes((Element)image, index);
            this.translateAttachmentNodes((Element)image, index);
            this.translateScannerSettings((Element)image, index);
            this.translateFilterSettings((Element)image, index);
            this.translateTimestamps((Element)image, index);
            this.translateLaserLines((Element)image, index);
            this.translateROIs((Element)image, index);
            this.translateSingleROIs((Element)image, index);
            this.translateDetectors((Element)image, index);
            ArrayDeque<String> nameStack = new ArrayDeque<String>();
            this.populateOriginalMetadata((Element)image, nameStack);
            this.addUserCommentMeta((Element)image, i);
        }
        this.setSeries(0);
        int totalSeries = 0;
        for (Object count : (Object)this.tileCount) {
            totalSeries += count;
        }
        ArrayList newCore = new ArrayList();
        for (int i3 = 0; i3 < this.core.size(); ++i3) {
            for (int tile = 0; tile < this.tileCount[i3]; ++tile) {
                newCore.add(this.core.get(i3));
            }
        }
        this.core = newCore;
    }

    private void populateOriginalMetadata(Element root, Deque<String> nameStack) {
        String name = root.getNodeName();
        if (root.hasAttributes() && !name.equals("Element") && !name.equals("Attachment") && !name.equals("LMSDataContainerHeader")) {
            nameStack.push(name);
            String suffix = root.getAttribute("Identifier");
            String value = root.getAttribute("Variant");
            if (suffix == null || suffix.trim().length() == 0) {
                suffix = root.getAttribute("Description");
            }
            StringBuilder key = new StringBuilder();
            Iterator<String> nameStackIterator = nameStack.descendingIterator();
            while (nameStackIterator.hasNext()) {
                String k = nameStackIterator.next();
                key.append(k);
                key.append("|");
            }
            if (suffix != null && value != null && suffix.length() > 0 && value.length() > 0 && !suffix.equals("HighInteger") && !suffix.equals("LowInteger")) {
                this.addSeriesMetaList(key.toString() + suffix, value);
            } else {
                NamedNodeMap attributes = root.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (attr.getName().equals("HighInteger") || attr.getName().equals("LowInteger")) continue;
                    this.addSeriesMeta(key.toString() + attr.getName(), attr.getValue());
                }
            }
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            this.populateOriginalMetadata((Element)child, nameStack);
        }
        if (root.hasAttributes() && !name.equals("Element") && !name.equals("Attachment") && !name.equals("LMSDataContainerHeader")) {
            nameStack.pop();
        }
    }

    private void translateImageNames(Element imageNode, int image) {
        ArrayList<String> names = new ArrayList<String>();
        Element parent = imageNode;
        while ((parent = (Element)parent.getParentNode()) != null && !parent.getNodeName().equals("LEICA")) {
            if (!parent.getNodeName().equals("Element")) continue;
            names.add(parent.getAttribute("Name"));
        }
        this.imageNames[image] = "";
        for (int i = names.size() - 2; i >= 0; --i) {
            int n = image;
            this.imageNames[n] = this.imageNames[n] + (String)names.get(i);
            if (i <= 0) continue;
            int n2 = image;
            this.imageNames[n2] = this.imageNames[n2] + '/';
        }
    }

    private void translateDetectors(Element imageNode, int image) throws FormatException {
        NodeList definitions = this.getNodes(imageNode, "ATLConfocalSettingDefinition");
        if (definitions == null) {
            return;
        }
        ArrayList<String> channels = new ArrayList<String>();
        this.laserActive[image] = new ArrayList();
        int nextChannel = 0;
        for (int definition = 0; definition < definitions.getLength(); ++definition) {
            Element definitionNode = (Element)definitions.item(definition);
            String parentName = definitionNode.getParentNode().getNodeName();
            boolean isMaster = parentName.endsWith("Master");
            NodeList detectors = this.getNodes(definitionNode, "Detector");
            if (detectors == null) {
                return;
            }
            int count = 0;
            for (int d = 0; d < detectors.getLength(); ++d) {
                int channel;
                String v;
                Element detector = (Element)detectors.item(d);
                NodeList multibands = null;
                if (!isMaster) {
                    multibands = this.getNodes(definitionNode, "MultiBand");
                }
                Double gain = (v = detector.getAttribute("Gain")) == null || v.trim().isEmpty() ? null : new Double(v.trim());
                v = detector.getAttribute("Offset");
                Double offset = v == null || v.trim().isEmpty() ? null : new Double(v.trim());
                boolean active = "1".equals(detector.getAttribute("IsActive"));
                String c = detector.getAttribute("Channel");
                int n = channel = c == null || c.trim().length() == 0 ? 0 : Integer.parseInt(c);
                if (active) {
                    if (this.detectorIndexes[image] != null && this.detectorModels[image] != null) {
                        this.detectorModels[image].add(this.detectorIndexes[image].get(channel));
                    }
                    Element multiband = null;
                    if (multibands != null) {
                        for (int i = 0; i < multibands.getLength(); ++i) {
                            Element mb = (Element)multibands.item(i);
                            if (channel != Integer.parseInt(mb.getAttribute("Channel"))) continue;
                            multiband = mb;
                            break;
                        }
                    }
                    if (multiband != null) {
                        String dye = multiband.getAttribute("DyeName");
                        if (!channels.contains(dye)) {
                            channels.add(dye);
                        }
                        double cutIn = new Double(multiband.getAttribute("LeftWorld"));
                        double cutOut = new Double(multiband.getAttribute("RightWorld"));
                        if ((int)cutIn > 0) {
                            Length in;
                            if (this.cutIns[image] == null) {
                                this.cutIns[image] = new ArrayList();
                            }
                            if ((in = FormatTools.getCutIn(Double.valueOf(Math.round(cutIn)))) != null) {
                                this.cutIns[image].add(in);
                            }
                        }
                        if ((int)cutOut > 0) {
                            Length out;
                            if (this.cutOuts[image] == null) {
                                this.cutOuts[image] = new ArrayList();
                            }
                            if ((out = FormatTools.getCutOut(Double.valueOf(Math.round(cutOut)))) != null) {
                                this.cutOuts[image].add(out);
                            }
                        }
                    } else {
                        channels.add("");
                    }
                    if (!isMaster) {
                        if (channel < nextChannel) {
                            nextChannel = 0;
                        }
                        if (nextChannel < this.getEffectiveSizeC()) {
                            if (this.gains[image] != null) {
                                this.gains[image][nextChannel] = gain;
                            }
                            if (this.detectorOffsets[image] != null) {
                                this.detectorOffsets[image][nextChannel] = offset;
                            }
                        }
                        ++nextChannel;
                    }
                } else {
                    ++count;
                }
                if (!active || this.activeDetector[image] == null) continue;
                this.activeDetector[image].add(active);
            }
            if (isMaster) continue;
            this.laserActive[image].add(count < detectors.getLength());
        }
        if (channels != null && this.channelNames[image] != null) {
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                int index = i + channels.size() - this.getEffectiveSizeC();
                if (index < 0 || index >= channels.size() || this.channelNames[image][i] != null && !this.channelNames[image][i].trim().isEmpty()) continue;
                this.channelNames[image][i] = (String)channels.get(index);
            }
        }
    }

    private void translateROIs(Element imageNode, int image) throws FormatException {
        NodeList rois = this.getNodes(imageNode, "Annotation");
        if (rois == null) {
            return;
        }
        this.imageROIs[image] = new ROI[rois.getLength()];
        for (int r = 0; r < rois.getLength(); ++r) {
            String color;
            Element roiNode = (Element)rois.item(r);
            ROI roi = new ROI();
            String type = roiNode.getAttribute("type");
            if (type != null && !type.trim().isEmpty()) {
                roi.type = Integer.parseInt(type.trim());
            }
            if ((color = roiNode.getAttribute("color")) != null && !color.trim().isEmpty()) {
                roi.color = Long.parseLong(color.trim());
            }
            roi.name = roiNode.getAttribute("name");
            roi.fontName = roiNode.getAttribute("fontName");
            roi.fontSize = roiNode.getAttribute("fontSize");
            roi.transX = this.parseDouble(roiNode.getAttribute("transTransX"));
            roi.transY = this.parseDouble(roiNode.getAttribute("transTransY"));
            roi.scaleX = this.parseDouble(roiNode.getAttribute("transScalingX"));
            roi.scaleY = this.parseDouble(roiNode.getAttribute("transScalingY"));
            roi.rotation = this.parseDouble(roiNode.getAttribute("transRotation"));
            String linewidth = roiNode.getAttribute("linewidth");
            try {
                if (linewidth != null && !linewidth.trim().isEmpty()) {
                    roi.linewidth = Integer.parseInt(linewidth.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            roi.text = roiNode.getAttribute("text");
            NodeList vertices = this.getNodes(roiNode, "Vertex");
            if (vertices == null) continue;
            for (int v = 0; v < vertices.getLength(); ++v) {
                Element vertex = (Element)vertices.item(v);
                String xx = vertex.getAttribute("x");
                String yy = vertex.getAttribute("y");
                if (xx != null && !xx.trim().isEmpty()) {
                    roi.x.add(this.parseDouble(xx.trim()));
                }
                if (yy == null || yy.trim().isEmpty()) continue;
                roi.y.add(this.parseDouble(yy.trim()));
            }
            this.imageROIs[image][r] = roi;
            if (this.getNodes(imageNode, "ROI") == null) continue;
            this.alternateCenter = true;
        }
    }

    private void translateSingleROIs(Element imageNode, int image) throws FormatException {
        if (this.imageROIs[image] != null) {
            return;
        }
        NodeList children = this.getNodes(imageNode, "ROI");
        if (children == null) {
            return;
        }
        if ((children = this.getNodes((Element)children.item(0), "Children")) == null) {
            return;
        }
        if ((children = this.getNodes((Element)children.item(0), "Element")) == null) {
            return;
        }
        this.imageROIs[image] = new ROI[children.getLength()];
        for (int r = 0; r < children.getLength(); ++r) {
            String color;
            NodeList rois = this.getNodes((Element)children.item(r), "ROISingle");
            Element roiNode = (Element)rois.item(0);
            ROI roi = new ROI();
            String type = roiNode.getAttribute("RoiType");
            if (type != null && !type.trim().isEmpty()) {
                roi.type = Integer.parseInt(type.trim());
            }
            if ((color = roiNode.getAttribute("Color")) != null && !color.trim().isEmpty()) {
                roi.color = Long.parseLong(color.trim());
            }
            Element parent = (Element)roiNode.getParentNode();
            parent = (Element)parent.getParentNode();
            roi.name = parent.getAttribute("Name");
            NodeList vertices = this.getNodes(roiNode, "P");
            double sizeX = this.physicalSizeXs.get(image);
            double sizeY = this.physicalSizeYs.get(image);
            for (int v = 0; v < vertices.getLength(); ++v) {
                Element vertex = (Element)vertices.item(v);
                String xx = vertex.getAttribute("X");
                String yy = vertex.getAttribute("Y");
                if (xx != null && !xx.trim().isEmpty()) {
                    roi.x.add(this.parseDouble(xx.trim()) / sizeX);
                }
                if (yy == null || yy.trim().isEmpty()) continue;
                roi.y.add(this.parseDouble(yy.trim()) / sizeY);
            }
            Element transform = (Element)this.getNodes(roiNode, "Transformation").item(0);
            roi.rotation = this.parseDouble(transform.getAttribute("Rotation"));
            Element scaling = (Element)this.getNodes(transform, "Scaling").item(0);
            roi.scaleX = this.parseDouble(scaling.getAttribute("XScale"));
            roi.scaleY = this.parseDouble(scaling.getAttribute("YScale"));
            Element translation = (Element)this.getNodes(transform, "Translation").item(0);
            roi.transX = this.parseDouble(translation.getAttribute("X")) / sizeX;
            roi.transY = this.parseDouble(translation.getAttribute("Y")) / sizeY;
            this.imageROIs[image][r] = roi;
        }
    }

    private void translateLaserLines(Element imageNode, int image) throws FormatException {
        NodeList aotfLists = this.getNodes(imageNode, "AotfList");
        if (aotfLists == null || aotfLists.getLength() == 0) {
            return;
        }
        this.laserWavelength[image] = new ArrayList();
        this.laserIntensity[image] = new ArrayList();
        this.laserFrap[image] = new ArrayList();
        int baseIntensityIndex = 0;
        for (int channel = 0; channel < aotfLists.getLength(); ++channel) {
            Element aotf = (Element)aotfLists.item(channel);
            NodeList laserLines = this.getNodes(aotf, "LaserLineSetting");
            if (laserLines == null) {
                return;
            }
            String gpName = aotf.getParentNode().getParentNode().getNodeName();
            boolean isMaster = gpName.endsWith("Sequential_Master") || gpName.endsWith("Attachment");
            this.laserFrap[image].add(gpName.endsWith("FRAP_Master"));
            for (int laser = 0; laser < laserLines.getLength(); ++laser) {
                int qualifier;
                Element laserLine = (Element)laserLines.item(laser);
                if (isMaster) continue;
                String lineIndex = laserLine.getAttribute("LineIndex");
                String qual = laserLine.getAttribute("Qualifier");
                int index = lineIndex == null || lineIndex.trim().isEmpty() ? 0 : Integer.parseInt(lineIndex.trim());
                int n = qualifier = qual == null || qual.trim().isEmpty() ? 0 : Integer.parseInt(qual.trim());
                if ((index += 2 - qualifier / 10) < 0) continue;
                String v = laserLine.getAttribute("LaserLine");
                Double wavelength = 0.0;
                if (v != null && !v.trim().isEmpty()) {
                    wavelength = new Double(v.trim());
                }
                if (index < this.laserWavelength[image].size()) {
                    this.laserWavelength[image].set(index, wavelength);
                } else {
                    for (int i = this.laserWavelength[image].size(); i < index; ++i) {
                        this.laserWavelength[image].add(0.0);
                    }
                    this.laserWavelength[image].add(wavelength);
                }
                String intensity = laserLine.getAttribute("IntensityDev");
                double realIntensity = intensity == null || intensity.trim().isEmpty() ? 0.0 : new Double(intensity.trim());
                realIntensity = 100.0 - realIntensity;
                int realIndex = baseIntensityIndex + index;
                if (realIndex < this.laserIntensity[image].size()) {
                    this.laserIntensity[image].set(realIndex, realIntensity);
                    continue;
                }
                while (realIndex < this.laserIntensity[image].size()) {
                    this.laserIntensity[image].add(100.0);
                }
                this.laserIntensity[image].add(realIntensity);
            }
            baseIntensityIndex += this.laserWavelength[image].size();
        }
    }

    private void translateTimestamps(Element imageNode, int image) throws FormatException {
        NodeList timeStampLists = this.getNodes(imageNode, "TimeStampList");
        if (timeStampLists == null) {
            return;
        }
        Element timeStampList = (Element)timeStampLists.item(0);
        this.timestamps[image] = new Double[this.getImageCount()];
        String numberOfTimeStamps = timeStampList.getAttribute("NumberOfTimeStamps");
        if (numberOfTimeStamps != null && !numberOfTimeStamps.isEmpty()) {
            String timeStampsRaw = timeStampList.getTextContent();
            List<String> timeStamps = Arrays.asList(timeStampsRaw.split(" "));
            for (int stamp = 0; stamp < timeStamps.size(); ++stamp) {
                if (stamp >= this.getImageCount()) continue;
                String timestamp = timeStamps.get(stamp);
                this.timestamps[image][stamp] = this.translateSingleTimestamp(timestamp);
            }
        } else {
            NodeList timestampNodes = this.getNodes(imageNode, "TimeStamp");
            if (timestampNodes != null) {
                for (int stamp = 0; stamp < timestampNodes.getLength(); ++stamp) {
                    if (stamp >= this.getImageCount()) continue;
                    Element timestamp = (Element)timestampNodes.item(stamp);
                    this.timestamps[image][stamp] = this.translateSingleTimestamp(timestamp);
                }
            } else {
                return;
            }
        }
        this.acquiredDate[image] = this.timestamps[image][0];
    }

    private double translateSingleTimestamp(String timestamp) {
        timestamp = timestamp.trim();
        int stampLowStart = Math.max(0, timestamp.length() - 8);
        int stampHighEnd = Math.max(0, stampLowStart);
        String stampHigh = timestamp.substring(0, stampHighEnd);
        String stampLow = timestamp.substring(stampLowStart, timestamp.length());
        long high = stampHigh == null || stampHigh.trim().isEmpty() ? 0L : Long.parseLong(stampHigh.trim(), 16);
        long low = stampLow == null || stampLow.trim().isEmpty() ? 0L : Long.parseLong(stampLow.trim(), 16);
        long milliseconds = DateTools.getMillisFromTicks(high, low);
        double seconds = (double)milliseconds / 1000.0;
        return seconds;
    }

    private double translateSingleTimestamp(Element timestamp) {
        String stampHigh = timestamp.getAttribute("HighInteger");
        String stampLow = timestamp.getAttribute("LowInteger");
        long high = stampHigh == null || stampHigh.trim().isEmpty() ? 0L : Long.parseLong(stampHigh.trim());
        long low = stampLow == null || stampLow.trim().isEmpty() ? 0L : Long.parseLong(stampLow.trim());
        long milliseconds = DateTools.getMillisFromTicks(high, low);
        double seconds = (double)milliseconds / 1000.0;
        return seconds;
    }

    private void translateFilterSettings(Element imageNode, int image) throws FormatException {
        NodeList filterSettings = this.getNodes(imageNode, "FilterSettingRecord");
        if (filterSettings == null) {
            return;
        }
        this.activeDetector[image] = new ArrayList();
        this.cutIns[image] = new ArrayList();
        this.cutOuts[image] = new ArrayList();
        this.filterModels[image] = new ArrayList();
        this.detectorIndexes[image] = new HashMap();
        int nextChannel = 0;
        for (int i = 0; i < filterSettings.getLength(); ++i) {
            Element filterSetting = (Element)filterSettings.item(i);
            String object = filterSetting.getAttribute("ObjectName");
            String attribute = filterSetting.getAttribute("Attribute");
            String objectClass = filterSetting.getAttribute("ClassName");
            String variant = filterSetting.getAttribute("Variant");
            String data = filterSetting.getAttribute("Data");
            if (attribute.equals("NumericalAperture")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                this.lensNA[image] = new Double(variant.trim());
                continue;
            }
            if (attribute.equals("OrderNumber")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                this.serialNumber[image] = variant.trim();
                continue;
            }
            if (objectClass.equals("CDetectionUnit")) {
                int channel;
                if (!attribute.equals("State") || (channel = this.getChannelIndex(filterSetting)) < 0) continue;
                this.detectorIndexes[image].put(new Integer(data), object);
                this.activeDetector[image].add("Active".equals(variant.trim()));
                continue;
            }
            if (attribute.equals("Objective")) {
                StringTokenizer tokens = new StringTokenizer(variant, " ");
                boolean foundMag = false;
                StringBuilder model = new StringBuilder();
                while (!foundMag) {
                    String token = tokens.nextToken();
                    int x = token.indexOf(120);
                    if (x != -1) {
                        foundMag = true;
                        String na = token.substring(x + 1);
                        if (na != null && !na.trim().isEmpty()) {
                            this.lensNA[image] = new Double(na.trim());
                        }
                        if ((na = token.substring(0, x)) == null || na.trim().isEmpty()) continue;
                        this.magnification[image] = new Double(na.trim());
                        continue;
                    }
                    model.append(token);
                    model.append(" ");
                }
                String immersion = "Other";
                if (tokens.hasMoreTokens() && ((immersion = tokens.nextToken()) == null || immersion.trim().isEmpty())) {
                    immersion = "Other";
                }
                this.immersions[image] = immersion;
                String correction = "Other";
                if (tokens.hasMoreTokens() && ((correction = tokens.nextToken()) == null || correction.trim().isEmpty())) {
                    correction = "Other";
                }
                this.corrections[image] = correction;
                this.objectiveModels[image] = model.toString().trim();
                continue;
            }
            if (attribute.equals("RefractionIndex")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                this.refractiveIndex[image] = new Double(variant.trim());
                continue;
            }
            if (attribute.equals("XPos")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                Double number = Double.valueOf(variant.trim());
                this.posX[image] = new Length(number, UNITS.REFERENCEFRAME);
                continue;
            }
            if (attribute.equals("YPos")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                Double number = Double.valueOf(variant.trim());
                this.posY[image] = new Length(number, UNITS.REFERENCEFRAME);
                continue;
            }
            if (attribute.equals("ZPos")) {
                if (variant == null || variant.trim().isEmpty()) continue;
                Double number = Double.valueOf(variant.trim());
                this.posZ[image] = new Length(number, UNITS.REFERENCEFRAME);
                continue;
            }
            if (!objectClass.equals("CSpectrophotometerUnit")) continue;
            Double v = null;
            try {
                v = Double.parseDouble(variant);
            }
            catch (NumberFormatException foundMag) {
                // empty catch block
            }
            String description = filterSetting.getAttribute("Description");
            if (description.endsWith("(left)")) {
                Length in;
                this.filterModels[image].add(object);
                if (v == null || !(v > 0.0) || (in = FormatTools.getCutIn(v)) == null) continue;
                this.cutIns[image].add(in);
                continue;
            }
            if (description.endsWith("(right)")) {
                Length out;
                if (v == null || !(v > 0.0) || (out = FormatTools.getCutOut(v)) == null) continue;
                this.cutOuts[image].add(out);
                continue;
            }
            if (!attribute.equals("Stain") || nextChannel >= this.channelNames[image].length) continue;
            this.channelNames[image][nextChannel++] = variant;
        }
    }

    private void translateScannerSettings(Element imageNode, int image) throws FormatException {
        NodeList scannerSettings = this.getNodes(imageNode, "ScannerSettingRecord");
        if (scannerSettings == null) {
            return;
        }
        this.expTimes[image] = new Double[this.getEffectiveSizeC()];
        this.gains[image] = new Double[this.getEffectiveSizeC()];
        this.detectorOffsets[image] = new Double[this.getEffectiveSizeC()];
        this.channelNames[image] = new String[this.getEffectiveSizeC()];
        this.exWaves[image] = new Double[this.getEffectiveSizeC()];
        this.detectorModels[image] = new ArrayList();
        for (int i = 0; i < scannerSettings.getLength(); ++i) {
            Element scannerSetting = (Element)scannerSettings.item(i);
            String id = scannerSetting.getAttribute("Identifier");
            if (id == null) {
                id = "";
            }
            String suffix = scannerSetting.getAttribute("Identifier");
            String value = scannerSetting.getAttribute("Variant");
            if (id.equals("SystemType")) {
                this.microscopeModels[image] = value;
                continue;
            }
            if (id.equals("dblPinhole")) {
                if (value == null || value.trim().isEmpty()) continue;
                this.pinholes[image] = Double.parseDouble(value.trim()) * 1000000.0;
                continue;
            }
            if (id.equals("dblZoom")) {
                if (value == null || value.trim().isEmpty()) continue;
                this.zooms[image] = new Double(value.trim());
                continue;
            }
            if (id.equals("dblStepSize")) {
                if (value == null || value.trim().isEmpty()) continue;
                this.zSteps[image] = Double.parseDouble(value.trim()) * 1000000.0;
                continue;
            }
            if (id.equals("nDelayTime_s")) {
                if (value == null || value.trim().isEmpty()) continue;
                this.tSteps[image] = new Double(value.trim());
                continue;
            }
            if (id.equals("CameraName")) {
                this.detectorModels[image].add(value);
                continue;
            }
            if (id.equals("eDirectional")) {
                this.addSeriesMeta("Reverse X orientation", "1".equals(value.trim()));
                continue;
            }
            if (id.equals("eDirectionalY")) {
                this.addSeriesMeta("Reverse Y orientation", "1".equals(value.trim()));
                continue;
            }
            if (id.indexOf("WFC") != 1) continue;
            int c = 0;
            try {
                c = Integer.parseInt(id.replaceAll("\\D", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (c < 0 || c >= this.getEffectiveSizeC()) continue;
            if (id.endsWith("ExposureTime")) {
                if (value == null || value.trim().isEmpty()) continue;
                this.expTimes[image][c] = new Double(value.trim());
                continue;
            }
            if (id.endsWith("Gain")) {
                if (value == null || value.trim().isEmpty()) continue;
                this.gains[image][c] = new Double(value.trim());
                continue;
            }
            if (id.endsWith("WaveLength")) {
                Double exWave;
                if (value == null || value.trim().isEmpty() || !((exWave = new Double(value.trim())) > 0.0)) continue;
                this.exWaves[image][c] = exWave;
                continue;
            }
            if (!id.endsWith("UesrDefName") && !id.endsWith("UserDefName") || value.equals("None") || this.channelNames[image][c] != null && !this.channelNames[image][c].trim().isEmpty()) continue;
            this.channelNames[image][c] = value;
        }
    }

    private void translateAttachmentNodes(Element imageNode, int image) throws FormatException {
        NodeList attachmentNodes = this.getNodes(imageNode, "Attachment");
        if (attachmentNodes == null) {
            return;
        }
        for (int i = 0; i < attachmentNodes.getLength(); ++i) {
            Element attachment = (Element)attachmentNodes.item(i);
            String attachmentName = attachment.getAttribute("Name");
            if ("ContextDescription".equals(attachmentName)) {
                this.descriptions[image] = attachment.getAttribute("Content");
                continue;
            }
            if (!"TileScanInfo".equals(attachmentName)) continue;
            NodeList tiles = this.getNodes(attachment, "Tile");
            for (int tile = 0; tile < tiles.getLength(); ++tile) {
                Double number;
                Element tileNode = (Element)tiles.item(tile);
                String posX = tileNode.getAttribute("PosX");
                String posY = tileNode.getAttribute("PosY");
                if (posX != null) {
                    try {
                        number = Double.valueOf(posX);
                        this.fieldPosX.add(new Length(number, UNITS.REFERENCEFRAME));
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug("", e);
                        this.fieldPosX.add(null);
                    }
                }
                if (posY == null) continue;
                try {
                    number = Double.valueOf(posY);
                    this.fieldPosY.add(new Length(number, UNITS.REFERENCEFRAME));
                    continue;
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("", e);
                    this.fieldPosY.add(null);
                }
            }
        }
    }

    private void addUserCommentMeta(Element imageNode, int image) throws FormatException {
        NodeList attachmentNodes = this.getNodes(imageNode, "User-Comment");
        if (attachmentNodes == null) {
            return;
        }
        for (int i = 0; i < attachmentNodes.getLength(); ++i) {
            Node attachment = attachmentNodes.item(i);
            this.addSeriesMeta("User-Comment[" + i + "]", attachment.getTextContent());
            if (i != 0 || this.descriptions[image] != null) continue;
            this.descriptions[image] = attachment.getTextContent();
        }
    }

    private void translateImageNodes(Element imageNode, int i) throws FormatException {
        CoreMetadata ms = (CoreMetadata)this.core.get(i);
        ms.orderCertain = true;
        ms.metadataComplete = true;
        ms.littleEndian = true;
        ms.falseColor = true;
        NodeList channels = this.getChannelDescriptionNodes(imageNode);
        NodeList dimensions = this.getDimensionDescriptionNodes(imageNode);
        HashMap<Long, String> bytesPerAxis = new HashMap<Long, String>();
        Double physicalSizeX = null;
        Double physicalSizeY = null;
        Double physicalSizeZ = null;
        ms.sizeC = channels.getLength();
        for (int ch = 0; ch < channels.getLength(); ++ch) {
            long bytes;
            Element channel = (Element)channels.item(ch);
            this.lutNames.add(channel.getAttribute("LUTName"));
            String bytesInc = channel.getAttribute("BytesInc");
            long l = bytes = bytesInc == null || bytesInc.trim().isEmpty() ? 0L : Long.parseLong(bytesInc.trim());
            if (bytes <= 0L) continue;
            bytesPerAxis.put(bytes, "C");
        }
        int extras = 1;
        block8: for (int dim = 0; dim < dimensions.getLength(); ++dim) {
            Element dimension = (Element)dimensions.item(dim);
            String v = dimension.getAttribute("DimID");
            int id = v == null || v.trim().isEmpty() ? 0 : Integer.parseInt(v.trim());
            v = dimension.getAttribute("NumberOfElements");
            int len = v == null || v.trim().isEmpty() ? 0 : Integer.parseInt(v.trim());
            v = dimension.getAttribute("BytesInc");
            long nBytes = v == null || v.trim().isEmpty() ? 0L : Long.parseLong(v.trim());
            v = dimension.getAttribute("Length");
            Double physicalLen = StringUtils.isBlank(v) ? Double.valueOf(0.0) : new Double(v.trim());
            String unit = dimension.getAttribute("Unit");
            double offByOnePhysicalLen = 0.0;
            if (len > 1) {
                offByOnePhysicalLen = physicalLen / (double)len;
                physicalLen = physicalLen / (double)(len - 1);
            } else {
                physicalLen = 0.0;
            }
            if (unit.equals("Ks")) {
                physicalLen = physicalLen / 1000.0;
                offByOnePhysicalLen /= 1000.0;
            } else if (unit.equals("m")) {
                physicalLen = physicalLen * 1000000.0;
                offByOnePhysicalLen *= 1000000.0;
            }
            boolean oldPhysicalSize = this.useOldPhysicalSizeCalculation();
            switch (id) {
                case 1: {
                    ms.sizeX = len;
                    boolean bl = ms.rgb = nBytes % 3L == 0L;
                    if (ms.rgb) {
                        nBytes /= 3L;
                    }
                    ms.pixelType = FormatTools.pixelTypeFromBytes((int)nBytes, false, true);
                    physicalSizeX = oldPhysicalSize ? offByOnePhysicalLen : physicalLen;
                    continue block8;
                }
                case 2: {
                    if (ms.sizeY != 0) {
                        if (ms.sizeZ == 1) {
                            ms.sizeZ = len;
                            bytesPerAxis.put(nBytes, "Z");
                            physicalSizeZ = physicalLen;
                            continue block8;
                        }
                        if (ms.sizeT != 1) continue block8;
                        ms.sizeT = len;
                        bytesPerAxis.put(nBytes, "T");
                        continue block8;
                    }
                    ms.sizeY = len;
                    physicalSizeY = oldPhysicalSize ? offByOnePhysicalLen : physicalLen;
                    continue block8;
                }
                case 3: {
                    if (ms.sizeY == 0) {
                        ms.sizeY = len;
                        ms.sizeZ = 1;
                        bytesPerAxis.put(nBytes, "Y");
                        physicalSizeY = oldPhysicalSize ? offByOnePhysicalLen : physicalLen;
                        continue block8;
                    }
                    ms.sizeZ = len;
                    bytesPerAxis.put(nBytes, "Z");
                    physicalSizeZ = physicalLen;
                    continue block8;
                }
                case 4: {
                    if (ms.sizeY == 0) {
                        ms.sizeY = len;
                        ms.sizeT = 1;
                        bytesPerAxis.put(nBytes, "Y");
                        physicalSizeY = oldPhysicalSize ? offByOnePhysicalLen : physicalLen;
                        continue block8;
                    }
                    ms.sizeT = len;
                    bytesPerAxis.put(nBytes, "T");
                    continue block8;
                }
                case 10: {
                    int n = i;
                    this.tileCount[n] = this.tileCount[n] * len;
                    this.tileBytesInc[i] = nBytes;
                    continue block8;
                }
                default: {
                    extras *= len;
                }
            }
        }
        this.physicalSizeXs.add(physicalSizeX);
        this.physicalSizeYs.add(physicalSizeY);
        if (this.zSteps[i] == null && physicalSizeZ != null) {
            this.zSteps[i] = Math.abs(physicalSizeZ);
        }
        if (extras > 1) {
            if (ms.sizeZ == 1) {
                ms.sizeZ = extras;
            } else {
                ms.sizeT = ms.sizeT == 0 ? extras : (ms.sizeT *= extras);
            }
        }
        if (ms.sizeC == 0) {
            ms.sizeC = 1;
        }
        if (ms.sizeZ == 0) {
            ms.sizeZ = 1;
        }
        if (ms.sizeT == 0) {
            ms.sizeT = 1;
        }
        if (ms.sizeX == 0) {
            ms.sizeX = 1;
        }
        if (ms.sizeY == 0) {
            ms.sizeY = 1;
        }
        ms.interleaved = ms.rgb;
        ms.indexed = !ms.rgb;
        ms.imageCount = ms.sizeZ * ms.sizeT;
        ms.imageCount = !ms.rgb ? (ms.imageCount *= ms.sizeC) : (ms.imageCount *= ms.sizeC / 3);
        Object[] bytes = bytesPerAxis.keySet().toArray(new Long[0]);
        Arrays.sort(bytes);
        ms.dimensionOrder = "XY";
        if (this.getRGBChannelCount() == 1 || this.getRGBChannelCount() == this.getSizeC()) {
            if (this.getSizeC() > 1 && this.getSizeT() > 1) {
                ms.dimensionOrder = ms.dimensionOrder + 'C';
            }
            for (Object nBytes : bytes) {
                String axis = (String)bytesPerAxis.get(nBytes);
                if (ms.dimensionOrder.indexOf(axis) != -1) continue;
                ms.dimensionOrder = ms.dimensionOrder + axis;
            }
        }
        if (ms.dimensionOrder.indexOf(90) == -1) {
            ms.dimensionOrder = ms.dimensionOrder + 'Z';
        }
        if (ms.dimensionOrder.indexOf(67) == -1) {
            ms.dimensionOrder = ms.dimensionOrder + 'C';
        }
        if (ms.dimensionOrder.indexOf(84) == -1) {
            ms.dimensionOrder = ms.dimensionOrder + 'T';
        }
    }

    private NodeList getNodes(Element root, String nodeName) {
        NodeList nodes = root.getElementsByTagName(nodeName);
        if (nodes.getLength() == 0) {
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                NodeList childNodes;
                Node child = children.item(i);
                if (!(child instanceof Element) || (childNodes = this.getNodes((Element)child, nodeName)) == null) continue;
                return childNodes;
            }
            return null;
        }
        return nodes;
    }

    private Element getImageDescription(Element root) {
        return (Element)root.getElementsByTagName("ImageDescription").item(0);
    }

    private NodeList getChannelDescriptionNodes(Element root) {
        Element imageDescription = this.getImageDescription(root);
        Element channels = (Element)imageDescription.getElementsByTagName("Channels").item(0);
        return channels.getElementsByTagName("ChannelDescription");
    }

    private NodeList getDimensionDescriptionNodes(Element root) {
        Element imageDescription = this.getImageDescription(root);
        Element channels = (Element)imageDescription.getElementsByTagName("Dimensions").item(0);
        return channels.getElementsByTagName("DimensionDescription");
    }

    private int getChannelIndex(Element filterSetting) {
        int channel;
        String data = filterSetting.getAttribute("data");
        if (data == null || data.equals("")) {
            data = filterSetting.getAttribute("Data");
        }
        int n = channel = data == null || data.equals("") ? 0 : Integer.parseInt(data);
        if (channel < 0) {
            return -1;
        }
        return channel - 1;
    }

    private double parseDouble(String number) {
        if (number != null) {
            number = number.replaceAll(",", ".");
            try {
                return Double.parseDouble(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private Color getChannelColor(int colorCode) {
        switch (colorCode) {
            case 0: {
                return new Color(255, 0, 0, 255);
            }
            case 1: {
                return new Color(0, 255, 0, 255);
            }
            case 2: {
                return new Color(0, 0, 255, 255);
            }
            case 3: {
                return new Color(0, 255, 255, 255);
            }
            case 4: {
                return new Color(255, 0, 255, 255);
            }
            case 5: {
                return new Color(255, 255, 0, 255);
            }
        }
        return new Color(255, 255, 255, 255);
    }

    private int getTileIndex(int coreIndex) {
        int count = 0;
        for (int tile = 0; tile < this.tileCount.length; ++tile) {
            if (coreIndex < count + this.tileCount[tile]) {
                return tile;
            }
            count += this.tileCount[tile];
        }
        return -1;
    }

    class ROI {
        public static final int TEXT = 512;
        public static final int SCALE_BAR = 8192;
        public static final int POLYGON = 32;
        public static final int RECTANGLE = 16;
        public static final int LINE = 256;
        public static final int ARROW = 2;
        public int type;
        public List<Double> x = new ArrayList<Double>();
        public List<Double> y = new ArrayList<Double>();
        public double transX;
        public double transY;
        public double scaleX;
        public double scaleY;
        public double rotation;
        public long color;
        public int linewidth;
        public String text;
        public String fontName;
        public String fontSize;
        public String name;
        private boolean normalized = false;

        ROI() {
        }

        public void storeROI(MetadataStore store, int series, int roi, int roiIndex) {
            MetadataLevel level = LIFReader.this.getMetadataOptions().getMetadataLevel();
            if (level == MetadataLevel.NO_OVERLAYS || level == MetadataLevel.MINIMUM) {
                return;
            }
            String roiID = MetadataTools.createLSID("ROI", roi);
            store.setImageROIRef(roiID, series, roiIndex);
            store.setROIID(roiID, roi);
            store.setLabelID(MetadataTools.createLSID("Shape", roi, 0), roi, 0);
            if (this.text == null) {
                this.text = this.name;
            }
            store.setLabelText(this.text, roi, 0);
            if (this.fontSize != null) {
                try {
                    int size = (int)Double.parseDouble(this.fontSize);
                    Length fontSize = FormatTools.getFontSize(size);
                    if (fontSize != null) {
                        store.setLabelFontSize(fontSize, roi, 0);
                    }
                }
                catch (NumberFormatException size) {
                    // empty catch block
                }
            }
            Length l = new Length(this.linewidth, UNITS.PIXEL);
            store.setLabelStrokeWidth(l, roi, 0);
            if (!this.normalized) {
                this.normalize();
            }
            double cornerX = this.x.get(0);
            double cornerY = this.y.get(0);
            store.setLabelX(cornerX, roi, 0);
            store.setLabelY(cornerY, roi, 0);
            int centerX = ((CoreMetadata)((LIFReader)LIFReader.this).core.get((int)series)).sizeX / 2 - 1;
            int centerY = ((CoreMetadata)((LIFReader)LIFReader.this).core.get((int)series)).sizeY / 2 - 1;
            double roiX = (double)centerX + this.transX;
            double roiY = (double)centerY + this.transY;
            if (LIFReader.this.alternateCenter) {
                roiX = this.transX - 2.0 * cornerX;
                roiY = this.transY - 2.0 * cornerY;
            }
            String shapeID = MetadataTools.createLSID("Shape", roi, 1);
            switch (this.type) {
                case 32: {
                    StringBuilder points = new StringBuilder();
                    for (int i = 0; i < this.x.size(); ++i) {
                        points.append(this.x.get(i) + roiX);
                        points.append(",");
                        points.append(this.y.get(i) + roiY);
                        if (i >= this.x.size() - 1) continue;
                        points.append(" ");
                    }
                    store.setPolygonID(shapeID, roi, 1);
                    store.setPolygonPoints(points.toString(), roi, 1);
                    break;
                }
                case 16: 
                case 512: {
                    store.setRectangleID(shapeID, roi, 1);
                    store.setRectangleX(roiX - Math.abs(cornerX), roi, 1);
                    store.setRectangleY(roiY - Math.abs(cornerY), roi, 1);
                    double width = 2.0 * Math.abs(cornerX);
                    double height = 2.0 * Math.abs(cornerY);
                    store.setRectangleWidth(width, roi, 1);
                    store.setRectangleHeight(height, roi, 1);
                    break;
                }
                case 2: 
                case 256: 
                case 8192: {
                    store.setLineID(shapeID, roi, 1);
                    store.setLineX1(roiX + this.x.get(0), roi, 1);
                    store.setLineY1(roiY + this.y.get(0), roi, 1);
                    store.setLineX2(roiX + this.x.get(1), roi, 1);
                    store.setLineY2(roiY + this.y.get(1), roi, 1);
                }
            }
        }

        private void normalize() {
            double coordinate;
            int i;
            if (this.normalized) {
                return;
            }
            this.transX *= 1000000.0;
            this.transY *= 1000000.0;
            this.transX *= 1.0;
            this.transY *= 1.0;
            for (i = 0; i < this.x.size(); ++i) {
                coordinate = this.x.get(i) * 1000000.0;
                this.x.set(i, coordinate *= 1.0);
            }
            for (i = 0; i < this.y.size(); ++i) {
                coordinate = this.y.get(i) * 1000000.0;
                this.y.set(i, coordinate *= 1.0);
            }
            this.normalized = true;
        }
    }
}

