/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.LosslessJPEGCodec;
import loci.formats.gui.AWTImageTools;

public class JPEGCodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        if (data == null || data.length == 0) {
            return data;
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (options.bitsPerSample > 8) {
            throw new FormatException("> 8 bit data cannot be compressed with JPEG.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedImage img = AWTImageTools.makeImage(data, options.width, options.height, options.channels, options.interleaved, options.bitsPerSample / 8, false, options.littleEndian, options.signed);
        try {
            ImageIO.write((RenderedImage)img, "jpeg", out);
        }
        catch (IOException e) {
            throw new FormatException("Could not write JPEG data", e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        int i;
        BufferedImage b;
        long fp = in.getFilePointer();
        try {
            try {
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
            }
            catch (EOFException e) {
                in.seek(fp);
            }
            b = ImageIO.read(new BufferedInputStream(new DataInputStream(in), 8192));
        }
        catch (IOException exc) {
            in.seek(fp);
            return new LosslessJPEGCodec().decompress(in, options);
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[][] buf = AWTImageTools.getPixelBytes(b, options.littleEndian);
        if (options.ycbcr && buf.length == 3) {
            int nBytes = buf[0].length / (b.getWidth() * b.getHeight());
            int mask = (int)(Math.pow(2.0, nBytes * 8) - 1.0);
            for (i = 0; i < buf[0].length; i += nBytes) {
                double y = DataTools.bytesToInt(buf[0], i, nBytes, options.littleEndian);
                double cb = DataTools.bytesToInt(buf[1], i, nBytes, options.littleEndian);
                double cr = DataTools.bytesToInt(buf[2], i, nBytes, options.littleEndian);
                cb = Math.max(0.0, cb - 128.0);
                cr = Math.max(0.0, cr - 128.0);
                int red = (int)(y + 1.402 * cr);
                int green = (int)(y - 0.34414 * cb - 0.71414 * cr);
                int blue = (int)(y + 1.772 * cb);
                red = Math.min(red, mask) & mask;
                green = Math.min(green, mask) & mask;
                blue = Math.min(blue, mask) & mask;
                DataTools.unpackBytes(red, buf[0], i, nBytes, options.littleEndian);
                DataTools.unpackBytes(green, buf[1], i, nBytes, options.littleEndian);
                DataTools.unpackBytes(blue, buf[2], i, nBytes, options.littleEndian);
            }
        }
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else if (options.interleaved) {
            int next = 0;
            for (i = 0; i < buf[0].length; ++i) {
                for (int j = 0; j < buf.length; ++j) {
                    rtn[next++] = buf[j][i];
                }
            }
        } else {
            for (int i2 = 0; i2 < buf.length; ++i2) {
                System.arraycopy(buf[i2], 0, rtn, i2 * buf[0].length, buf[i2].length);
            }
        }
        return rtn;
    }
}

