/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import loci.formats.FilePattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisGuesser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AxisGuesser.class);
    public static final int UNKNOWN_AXIS = 0;
    public static final int Z_AXIS = 1;
    public static final int T_AXIS = 2;
    public static final int C_AXIS = 3;
    public static final int S_AXIS = 4;
    public static final Set<String> Z_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("fp", "sec", "z", "zs", "focal", "focalplane")));
    public static final Set<String> T_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("t", "tl", "tp", "time")));
    public static final Set<String> C_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("c", "ch", "w", "wavelength")));
    public static final Set<String> S_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("s", "series", "sp")));
    protected static final String ONE = "1";
    protected static final String TWO = "2";
    protected static final String THREE = "3";
    protected FilePattern fp;
    protected String dimOrder;
    protected String newOrder;
    protected int[] axisTypes;
    protected boolean certain;

    public AxisGuesser(FilePattern fp, String dimOrder, int sizeZ, int sizeT, int sizeC, boolean isCertain) {
        char[] ch;
        this.fp = fp;
        this.dimOrder = dimOrder;
        this.newOrder = dimOrder;
        String[] prefixes = fp.getPrefixes();
        String suffix = fp.getSuffix();
        String[][] elements = fp.getElements();
        this.axisTypes = new int[elements.length];
        boolean foundZ = false;
        boolean foundT = false;
        boolean foundC = false;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            int third;
            int f;
            int l;
            String p = prefixes[i].toLowerCase();
            ch = p.toCharArray();
            for (l = ch.length - 1; l >= 0 && (ch[l] >= '0' && ch[l] <= '9' || ch[l] == ' ' || ch[l] == '-' || ch[l] == '_' || ch[l] == '.'); --l) {
            }
            for (f = l; f >= 0 && ch[f] >= 'a' && ch[f] <= 'z'; --f) {
            }
            if (Z_PREFIXES.contains(p = p.substring(f + 1, l + 1))) {
                this.axisTypes[i] = 1;
                foundZ = true;
                continue;
            }
            if (T_PREFIXES.contains(p)) {
                this.axisTypes[i] = 2;
                foundT = true;
                continue;
            }
            if (C_PREFIXES.contains(p)) {
                this.axisTypes[i] = 3;
                foundC = true;
                continue;
            }
            if (S_PREFIXES.contains(p)) {
                this.axisTypes[i] = 4;
                continue;
            }
            if (suffix.equalsIgnoreCase(".pic") && i == this.axisTypes.length - 1 && (elements[i].length == 2 && (elements[i][0].equals(ONE) || elements[i][0].equals(TWO)) && (elements[i][1].equals(TWO) || elements[i][1].equals(THREE)) || elements[i].length == 3 && elements[i][0].equals(ONE) && elements[i][1].equals(TWO) && elements[i][2].equals(THREE))) {
                this.axisTypes[i] = 3;
                continue;
            }
            if (elements[i].length != 2 && elements[i].length != 3) continue;
            char first = elements[i][0].toLowerCase().charAt(0);
            char second = elements[i][1].toLowerCase().charAt(0);
            int n = third = elements[i].length == 2 ? 98 : (int)elements[i][2].toLowerCase().charAt(0);
            if (first != 'r' && second != 'r' && third != 114 || first != 'g' && second != 'g' && third != 103 || first != 'b' && second != 'b' && third != 98) continue;
            this.axisTypes[i] = 3;
        }
        if (!isCertain && (foundZ && !foundT && sizeZ > 1 && sizeT == 1 || foundT && !foundZ && sizeT > 1 && sizeZ == 1)) {
            int indexZ = this.newOrder.indexOf(90);
            int indexT = this.newOrder.indexOf(84);
            ch = this.newOrder.toCharArray();
            ch[indexZ] = 84;
            ch[indexT] = 90;
            this.newOrder = new String(ch);
            int sz = sizeT;
            sizeT = sizeZ;
            sizeZ = sz;
        }
        boolean canBeZ = !foundZ && sizeZ == 1;
        boolean canBeT = !foundT && sizeT == 1;
        boolean canBeC = !foundC && sizeC == 1;
        this.certain = isCertain;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != 0) continue;
            this.certain = false;
            if (canBeZ) {
                this.axisTypes[i] = 1;
                canBeZ = false;
                continue;
            }
            if (canBeT) {
                this.axisTypes[i] = 2;
                canBeT = false;
                continue;
            }
            if (canBeC) {
                this.axisTypes[i] = 3;
                canBeC = false;
                continue;
            }
            char lastAxis = this.newOrder.charAt(this.newOrder.length() - 1);
            this.axisTypes[i] = lastAxis == 'C' ? 3 : (lastAxis == 'Z' ? 1 : 2);
        }
    }

    public FilePattern getFilePattern() {
        return this.fp;
    }

    public String getOriginalOrder() {
        return this.dimOrder;
    }

    public String getAdjustedOrder() {
        return this.newOrder;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public int[] getAxisTypes() {
        return this.axisTypes;
    }

    public void setAxisTypes(int[] axes) {
        this.axisTypes = axes;
    }

    public int getAxisCountZ() {
        return this.getAxisCount(1);
    }

    public int getAxisCountT() {
        return this.getAxisCount(2);
    }

    public int getAxisCountC() {
        return this.getAxisCount(3);
    }

    public int getAxisCountS() {
        return this.getAxisCount(4);
    }

    public int getAxisCount(int axisType) {
        int num = 0;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != axisType) continue;
            ++num;
        }
        return num;
    }

    public static int getAxisType(String label) {
        String lowerLabel = label.toLowerCase();
        for (String p : Z_PREFIXES) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 1;
        }
        for (String p : C_PREFIXES) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 3;
        }
        for (String p : T_PREFIXES) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 2;
        }
        for (String p : S_PREFIXES) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 4;
        }
        return 0;
    }
}

