/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import loci.common.Location;

public class CaseInsensitiveLocation
extends Location {
    private static final Cache cache = new Cache();

    public CaseInsensitiveLocation(String pathname) throws IOException {
        super(CaseInsensitiveLocation.findCaseInsensitive(new Location(pathname)));
    }

    public CaseInsensitiveLocation(Location file2) throws IOException {
        super(CaseInsensitiveLocation.findCaseInsensitive(file2));
    }

    public CaseInsensitiveLocation(File file2) throws IOException {
        super(CaseInsensitiveLocation.findCaseInsensitive(new Location(file2.getAbsolutePath())));
    }

    public CaseInsensitiveLocation(String parent, String child) throws IOException {
        super(CaseInsensitiveLocation.findCaseInsensitive(new Location(parent, child)));
    }

    public CaseInsensitiveLocation(CaseInsensitiveLocation parent, String child) throws IOException {
        super(CaseInsensitiveLocation.findCaseInsensitive(new Location(parent.getAbsolutePath(), child)));
    }

    public static void invalidateCache() {
        cache.invalidate();
    }

    public static void invalidateCache(File dir) {
        cache.invalidate(new Location(dir.getAbsolutePath()));
    }

    private static String findCaseInsensitive(Location name) throws IOException {
        return cache.lookup(name.getAbsoluteFile()).getAbsolutePath();
    }

    private static final class Cache {
        private HashMap<String, HashMap<String, String>> cache = new HashMap();

        private HashMap<String, String> fill(Location dir) throws IOException {
            String dirname = dir.getAbsolutePath();
            HashMap<String, String> s = this.cache.get(dirname);
            if (s == null && dir.exists()) {
                String[] files;
                s = new HashMap();
                this.cache.put(dirname, s);
                for (String name : files = dir.list()) {
                    String lower = name.toLowerCase();
                    if (s.containsKey(lower)) {
                        throw new IOException("Multiple files found for case-insensitive path");
                    }
                    s.put(lower, name);
                }
            }
            return s;
        }

        public void invalidate(Location dir) {
            String dirname = dir.getAbsolutePath();
            this.cache.remove(dirname);
        }

        public void invalidate() {
            this.cache.clear();
        }

        public Location lookup(Location name) throws IOException {
            String realname;
            String lower;
            String f;
            HashMap<String, String> s;
            Location parent = name.getParentFile();
            if (parent != null && (s = this.fill(parent)) != null && (f = s.get(lower = (realname = name.getName()).toLowerCase())) != null) {
                return new Location(parent, f);
            }
            return name;
        }
    }
}

